// Copyright 1999, 2002 Robert Buff
// Contact: http://robertbuff.com/uvm
//
// This file is part of Mtg-Book.
//
// Mtg-Book is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2 of the License,
// or (at your option) any later version.
//
// Mtg-Book is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Mtg-Book; if not, write to the 
//
// Free Software Foundation, Inc.
// 59 Temple Place, Suite 330
// Boston, MA 02111-1307
// USA

#if ! defined(_MTG_OPTIMIZER_)
#define _MTG_OPTIMIZER_

#include "MtgCurveContainer.h"
#include "MtgFileName.h"
#include "MtgObject.h"

MTG_BEGIN_NAMESPACE

class tFDEngine;
//class tFDOptInstance;
class tMCEngine;
class tMCOptInstance;
class tParser;
class tPathSpace;
class tPortfolio;


//
//   t O p t i m i z e r
//

class tOptimizer : public tObject {

    typedef tObject super;

        // Initialization can be fine-tuned by reading parameters
        // from file, depending on the method (MC or FD).

    tFileName m_InMultiplierFile;   // MC and FD

        // Optimization results can be saved to a number of files.
        // Depending on the method (MC or FD), the following file
        // names will be used.

    tFileName m_OutWeightFile;      // MC
    tFileName m_OutPathSpaceFile;   // MC
    tFileName m_OutMultiplierFile;  // MC and FD

        // Curve containers contain references to curves.
        // The optimizer might want to generate some special
        // ones, besides those listed in the evaluater.
        // The container is read by the engine; the optimizer
        // doesn't handle curve generation.

    tCurveContainer m_CurveContainer;

protected:

    struct tParseInfo : super::tParseInfoStub {
        bool m_bParam1;
        bool m_bParam2;
    };

protected:

    void copyFrom( const tOptimizer& Opt );

    tRetCode parseParam( tParser& Parser, tParseInfoStub& Info );

public:

    tOptimizer();
    tOptimizer( const tOptimizer& Opt );

    ~tOptimizer();

    tRetCode finalize();

    const tFileName& outWeightFile() const {
        return m_OutWeightFile;
    }

    const tCurveContainer& curveContainer() const {
        return m_CurveContainer;
    }

        // The optimizer class is more like a read-only template;
        // the engine asks it to create a worker instance which
        // it then uses to optimize.

        // So far, optimization works only for Monte
        // Carlo methods.

    virtual tRetCode createInstance( tFDEngine* pEngine,
        ... /* tFDOptInstance*& pOpt */ ) const {
        return NOT_AVAILABLE;
    }

    virtual tRetCode createInstance( tMCEngine* pEngine,
        tMCOptInstance*& pOpt ) const {
        return NOT_AVAILABLE;
    }

        // These functions are called from the engine or optimizer
        // instance, before the run:

    tRetCode loadMultipliers( const tPortfolio& Portfolio,
        tHeap<double>& Multiplier ) const;

        // These functions are called from the engine or optimizer
        // instance, after the run:

    tRetCode savePathSpace( const tPathSpace& PathSpace ) const;
    tRetCode savePathSpace( const tPathSpace& PathSpace,
        const tHeap<double>& Weight ) const;

    tRetCode saveWeights( const tHeap<double>& Weight ) const;

    tRetCode saveMultipliers( const tPortfolio& Portfolio,
        const tHeap<double>& Multiplier ) const;

    static tRetCode parse( tParser& Parser, tSystem& System, tObject*& pObj );
};

MTG_END_NAMESPACE

#endif
