// Copyright 1999, 2002 Robert Buff
// Contact: http://robertbuff.com/uvm
//
// This file is part of Mtg-Book.
//
// Mtg-Book is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2 of the License,
// or (at your option) any later version.
//
// Mtg-Book is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Mtg-Book; if not, write to the 
//
// Free Software Foundation, Inc.
// 59 Temple Place, Suite 330
// Boston, MA 02111-1307
// USA

#if ! defined(_MTG_PARSER_)
#define _MTG_PARSER_

#include "MtgScanner.h"
#include "MtgLookup.h"

MTG_BEGIN_NAMESPACE

class tEvaluate;
class tObject;
class tRepository;
class tShell;


//
//   t P a r s e r
//
    
class tParser : public tScanner {

    typedef tScanner super;

        // The repository is purely referenced; no memory
        // management is performed for it.

    tRepository* m_pRep;

        // A parser maintains only one shell object, which
        // acts as an intermediary between it, its repository,
        // and the Tcl interpreter. m_pShell is a reference,
        // and the tObject mechanism is used to hold it.

    tShell* m_pShell;

        // For top level objects:

    tRetCode parsePrefix( tObject& Obj );
    void movePrefix( const tObject& From, tObject* pTo );

    tRetCode scanTable( tHeap<double>& Value,
        tRetCode (super::*scanDouble)( double& ) );
    
    tRetCode scanRange( tHeap<double>& Value,
        tRetCode (tParser::*scanTable)( tHeap<double>& ), 
        tRetCode (super::*scanRange)( double&, double& ) );

        // Parsers cannot be copied; they exist only
        // for a unique parse session.

    tParser( const tParser& ) {
        throw tException( INTERNAL_ERROR );
    }

public:

    tParser();
    ~tParser();

    void setRepository( tRepository& Rep ) {
        setRepository( &Rep );
    }
    void setRepository( tRepository* pRep = 0 );

    void setShell( tShell& Shell ) {
        setShell( &Shell );
    }
    void setShell( tShell* pShell = 0 );

    bool hasShell() const {
        return m_pShell != 0;
    }

    tShell& shell() const {
        MTG_ASSERT( m_pShell != 0 );
        return *m_pShell;
    }

    bool hasRepository() const {
        return m_pRep != 0;
    }

    tRepository& repository() const {
        MTG_ASSERT( m_pRep != 0 );
        return *m_pRep;
    }

    bool beginOfObj();
    bool endOfObj();

    tRetCode scanBeginOfObj();
    tRetCode scanEndOfObj();

    tRetCode scanTable( tHeap<double>& Value );
    tRetCode scanPosTable( tHeap<double>& Value );
    tRetCode scanNonNegTable( tHeap<double>& Value );

    tRetCode scanPercentageTable( tHeap<double>& Value );
    tRetCode scanPosPercentageTable( tHeap<double>& Value );
    tRetCode scanNonNegPercentageTable( tHeap<double>& Value );

    tRetCode scanRange( tHeap<double>& Value );
    tRetCode scanPosRange( tHeap<double>& Value );
    tRetCode scanNonNegRange( tHeap<double>& Value );

    tRetCode scanPercentageRange( tHeap<double>& Value );
    tRetCode scanPosPercentageRange( tHeap<double>& Value );
    tRetCode scanNonNegPercentageRange( tHeap<double>& Value );

    tObject* findObject( const char* sName = 0 ) const;

    tRetCode parseObject( tObject*& pObj );

    tRetCode parseObjects();
    tRetCode parseObjects( tEvaluate*& pEvaluate );
    tRetCode parseObjects( tEvaluate*& pEvaluate, tRepository& Rep );
};

MTG_END_NAMESPACE

#endif
