// Copyright 1999, 2002 Robert Buff
// Contact: http://robertbuff.com/uvm
//
// This file is part of Mtg-Book.
//
// Mtg-Book is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2 of the License,
// or (at your option) any later version.
//
// Mtg-Book is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Mtg-Book; if not, write to the 
//
// Free Software Foundation, Inc.
// 59 Temple Place, Suite 330
// Boston, MA 02111-1307
// USA

#if ! defined(_MTG_RANDOM_)
#define _MTG_RANDOM_

#include "MtgHeap.h"
#include "MtgHeap2.h"

#if defined(_WIN32)
    #include <windows.h>
#endif

MTG_BEGIN_NAMESPACE


//
//   t R a n d o m
//

class tRandom {

        // This random number generator is based on 
        // ranlib.c in netlib; see http://gams.nist.gov.

        // Disadvantage: there is only one random number
        // source per process. No multithreading; one should
        // make all the global stuff in ranlib class-local,
        // so one can have several random number generators
        // that don't interfere with each other. To alleviate
        // this, the seeds and the current generator id are
        // retrieved after each call, and reset before the
        // next. Blocking is used during random number
        // generation on Win32.

    long m_nSeed1;
    long m_nSeed2;
    long m_nGenId;

    void setSeed( long nSeed1, long nSeed2, long nGenId );
    void setSeed();
    void getSeed();

    void lock();
    void unlock();

#if defined(_WIN32)
    static void initialize();

    static long m_nInitialized;
    static CRITICAL_SECTION m_Critical;
#endif

public:

    tRandom();
    tRandom( long nSeed1, long nSeed2 );
    tRandom( const tRandom& Random );

    tRandom& operator=( const tRandom& Random );

    void setSeed( long nSeed1, long nSeed2 );
    void getSeed( long& nSeed1, long& nSeed2 );

        // Generate random numbers:

    double uniform();

    void uniform( tHeap<double>& Seq );
    void uniform( tHeap2<double>& Seq );

    double normal();

    void normal( tHeap<double>& Seq );
    void normal( tHeap2<double>& Seq );
};

MTG_END_NAMESPACE

#endif

