// Copyright 1999, 2002 Robert Buff
// Contact: http://robertbuff.com/uvm
//
// This file is part of Mtg-Book.
//
// Mtg-Book is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2 of the License,
// or (at your option) any later version.
//
// Mtg-Book is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Mtg-Book; if not, write to the 
//
// Free Software Foundation, Inc.
// 59 Temple Place, Suite 330
// Boston, MA 02111-1307
// USA

#if ! defined(_MTG_SAMPLE_PATH_)
#define _MTG_SAMPLE_PATH_

#include "MtgHeap2.h"

MTG_BEGIN_NAMESPACE

class tRandom;


//
//   t S a m p l e P a t h
//

class tSamplePath {

    int m_nNumOfFactors;
    int m_nNumOfSamples;

    long m_nSeed1;
    long m_nSeed2;

        // cumulative linear transformation factors, for
        // reconstruction:

    double m_gAlpha;
    double m_gBeta;

        // a 2-dimensional array of normal random variables:

    tHeap2<double> m_Sample;

    void copyFrom( const tSamplePath& Path );

public:

    tSamplePath();
    tSamplePath( int nNumOfFactors, int nNumOfSamples );
    tSamplePath( const tSamplePath& Path );

    tSamplePath& operator=( const tSamplePath& Path );

        // initialize:

    void setNumOfFactors( int nNumOfFactors );
    void setNumOfSamples( int nNumOfSamples );

        // construct:

    void build( long nSeed1, long nSeed2 );
    void build( tRandom& Random );

        // replace each value v with gAlpha * v + gBeta
        // (for variance reduction, for instance):

    void transform( double gAlpha, double gBeta = 0 );
    
        // maintain:

    void collapse();    // save memory
    void rebuild();     // restore m_Sample, using the seeds
                        // (note that transformation is also redone)

        // use:

    int numOfSamples() const {
        return m_nNumOfSamples;
    }

    int numOfFactors() const {
        return m_nNumOfFactors;
    }

    const double* operator[]( int nSample ) const {
        MTG_ASSERT( m_nNumOfFactors > 0 );
        MTG_ASSERT( 0 <= nSample && nSample < m_nNumOfSamples );
        return m_Sample[nSample];
    }
};

MTG_END_NAMESPACE

#endif
