// Copyright 1999, 2002 Robert Buff
// Contact: http://robertbuff.com/uvm
//
// This file is part of Mtg-Book.
//
// Mtg-Book is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2 of the License,
// or (at your option) any later version.
//
// Mtg-Book is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Mtg-Book; if not, write to the 
//
// Free Software Foundation, Inc.
// 59 Temple Place, Suite 330
// Boston, MA 02111-1307
// USA

#include "MtgIncl.h"
#include "MtgScenario.h"
#include "MtgFDEngine.h"
#include "MtgParser.h"
#include "MtgShockScenario.h"
#include "MtgWorstCase.h"

MTG_BEGIN_NAMESPACE


//
//   i n i t
//

void tScenario::init()

{
    reset();
}


//
//   r e s e t
//

void tScenario::reset()

{
    m_nPosition = xBuyer;
    m_bExhaustive = false;
    touch();
}


//
//   c o p y F r o m
//

void tScenario::copyFrom( const tScenario& Scenario )

{
    if( &Scenario == this )
        return;

    reset();
    m_nPosition = Scenario.m_nPosition;
    m_bExhaustive = Scenario.m_bExhaustive;
    super::copyFrom( Scenario );
}


//
//   p a r s e P a r a m
//

tRetCode tScenario::parseParam( tParser& Parser, tParseInfoStub& Info )

{
    tRetCode nRet;
    tParseInfo& I = static_cast<tParseInfo&>( Info );

    switch( Parser.curToken() ) {
        case xTokPosition :
        case xTokBuyer :
        case xTokSeller :
            if( I.m_bPosition )
                return Parser.setError( "position already defined" );

            if( Parser.curToken() == xTokPosition ) {
                if( ( nRet = Parser.readToken() ) != OK )
                    return nRet;
            }

            switch( Parser.curToken() ) {
                case xTokBuyer :
                    m_nPosition = xBuyer;
                    break;

                case xTokSeller :
                    m_nPosition = xSeller;
                    break;

                default :
                    return Parser.setError( INVALID_KEYWORD );
            }

            if( ( nRet = Parser.readToken() ) != OK )
                return nRet;

            I.m_bPosition = true;
            break;

        default :
            return super::parseParam( Parser, Info );
    }

    return OK;
}


//
//   t M o d e l
//

tScenario::tScenario()

{
    init();
}


//
//   t S c e n a r i o
//

tScenario::tScenario( const tScenario& Scenario )

{
    init();
    copyFrom( Scenario );
}


//
//   ~ t S c e n a r i o
//

tScenario::~tScenario()

{
}


//
//   f i n a l i z e
//

tRetCode tScenario::finalize()

{
    return super::finalize();
}


//
//   s e t E x h a u s t i v e
//

void tScenario::setExhaustive( bool bExhaustive )

{
    m_bExhaustive = bExhaustive;
}


//
//   r e f i n e E x P o l i c y
//

void tScenario::refineExPolicy( tFDEngine& Engine, int nBaseTag, 
    int nIndex, double gDontExValue, double gExValue, double gMultiplier,
    tExPolicy& nExPolicy )

{
}


//
//   r e f i n e E x P o l i c y
//

void tScenario::refineExPolicy( tFDEngine& Engine, int nBaseTag,
    int nIndex, double gDontExValue, double gExValue, double gMultiplier,
    tExPolicy& nExPolicy, tExPolicy& nExPolicy0 )

{
}


//
//   p a r s e
//

tRetCode tScenario::parse( tParser& Parser, tSystem& System, tObject*& pObj )

{
    tRetCode nRet;
    tScenario* pScenario;
    tToken nType;
    tParseInfo Info;

    Info.m_bPosition = false;
    Info.m_bParam1 = false;
    Info.m_bParam2 = false;
    Info.m_bParam3 = false;

    if( ( nRet = parseType( Parser, nType, xTokWorstCase ) ) != OK )
        return nRet;

    switch( nType ) {
        case xTokShock :
            pScenario = new tShockScenario;
            break;

        case xTokWorstCase :
            pScenario = new tWorstCase;
            break;

        default :
            return Parser.setError( INVALID_KEYWORD );
    }

    pScenario->setSystem( System );

    if( ( nRet = pScenario->super::parse( Parser, &Info ) ) != OK ) {
        delete pScenario;
        return nRet;
    }

    pObj = pScenario;
    return OK;
}

MTG_END_NAMESPACE