// Copyright 1999, 2002 Robert Buff
// Contact: http://robertbuff.com/uvm
//
// This file is part of Mtg-Book.
//
// Mtg-Book is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2 of the License,
// or (at your option) any later version.
//
// Mtg-Book is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Mtg-Book; if not, write to the 
//
// Free Software Foundation, Inc.
// 59 Temple Place, Suite 330
// Boston, MA 02111-1307
// USA

#if ! defined(_MTG_SHELL_)
#define _MTG_SHELL_

#include "MtgObject.h"
#include "MtgTclKernel.h"

MTG_BEGIN_NAMESPACE


//
//   t S h e l l
//

class tShell : public tObject {

    typedef tObject super;

    enum tType { 
        xTcl,
        xMtg,
        xOS
    };

    struct tTrigger {
        tType m_nType;
        char* m_sScript;
    };

    struct tAt : public tTrigger {
        long m_nTime;
    };

#if defined(_MTG_WITH_TCL)

        // The Tcl shell accesses Tcl through a kernel.
    tTclKernel m_Kernel;

#endif

    tHeap<tAt> m_At;
    tTrigger m_OnError;

        // While a shell is being parsed, another mtg script
        // can be incorporated. This script may not have
        // a shell object itself, or just a simple one.
        // The following counter counts the level of nesting.
        // It is incremented when another script is executed.

    int m_nNesting;

    tParser* m_pParser;

    void cleanup();

    void addAt( tType nType, long nTime, char* sScript );
    void setOnError( tType nType, char* sScript );

    tRetCode runTcl( const char* sScript );
    tRetCode runMtg( const char* sScript, bool bMakeSafe );
    tRetCode runOS( const char* sCmdLine );

    tRetCode parseAt( tParser& Parser, tType nType, char* sScript );

    tRetCode parsePrefix( tParser& Parser, tParseInfoStub& Info );
    tRetCode parseParam( tParser& Parser, tParseInfoStub& Info );

#if defined(_MTG_WITH_TCL)

    int createObjCmd( ClientData clientData,
        Tcl_Interp *pInterp, int objc, Tcl_Obj *CONST objv[],
        bool (*test)( const tObject* pObj ), Tcl_ObjCmdProc *CmdProc,
        Tcl_CmdDeleteProc *DeleteProc );

        // Tcl commands:

    static int createDriftCmd( ClientData clientData,
        Tcl_Interp *pInterp, int objc, Tcl_Obj *CONST objv[] );

    static int createBootstrapCmd( ClientData clientData,
        Tcl_Interp *pInterp, int objc, Tcl_Obj *CONST objv[] );

    static int shellFromTcl( ClientData clientData,    
        Tcl_Interp *pInterp, int objc, Tcl_Obj *CONST objv[] );

    static int dataFromTcl( ClientData clientData,
        Tcl_Interp *pInterp, int objc, Tcl_Obj *CONST objv[] );

#endif

        // Shells cannot be cloned.

    tObject* clone() const {
        throw tException( INTERNAL_ERROR );
        return 0;
    }

public:

    tShell();
    ~tShell();

    void setParser( tParser& Parser ) {
        setParser( &Parser );
    }

    void setParser( tParser* pParser );

    tRetCode finalize();

        // Run periodic scripts (forever):

    tRetCode run();

        // Run error handler:

    bool hasOnError() const {
        return m_OnError.m_sScript != 0;
    }
    tRetCode onError();

    tRetCode autoActivate() {
        return run();
    }

        // For tShell, there exists a non-static parse
        // function, since existing tShell objects can
        // be reused.

    tRetCode parse( tParser& Parser );

    static tRetCode parse( tParser& Parser, tSystem& System, tObject*& pObj );
};

MTG_END_NAMESPACE

#endif