// Copyright 1999, 2002 Robert Buff
// Contact: http://robertbuff.com/uvm
//
// This file is part of Mtg-Book.
//
// Mtg-Book is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2 of the License,
// or (at your option) any later version.
//
// Mtg-Book is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Mtg-Book; if not, write to the 
//
// Free Software Foundation, Inc.
// 59 Temple Place, Suite 330
// Boston, MA 02111-1307
// USA

#include "MtgIncl.h"
#include "MtgShockScenario.h"
#include "MtgEngine.h"
#include "MtgParser.h"

MTG_BEGIN_NAMESPACE


//
//   i n i t
//

void tShockScenario::init()

{
    reset();
}


//
//   p a r s e P a r a m
//

tRetCode tShockScenario::parseParam( tParser& Parser,
    tParseInfoStub& Info )

{
    tRetCode nRet;
    tParseInfo& I = static_cast<tParseInfo&>( Info );

    switch( Parser.curToken() ) {
        case xTokDuration :
            if( I.m_bParam1 )
                return Parser.setError( "duration already defined" );
            if( ( nRet = Parser.readToken() ) != OK ||
                ( nRet = Parser.scanInteger( m_nDuration, 1 ) ) != OK ) {
                return nRet;
            }
            I.m_bParam1 = true;
            break;

        case xTokPeriodicity :
            if( I.m_bParam2 )
                return Parser.setError( "periodicity already defined" );
            if( ( nRet = Parser.readToken() ) != OK ||
                ( nRet = Parser.scanInteger( m_nPeriodicity, 1 ) ) != OK ) {
                return nRet;
            }
            I.m_bParam2 = true;
            break;

        case xTokRepetitions :
            if( I.m_bParam3 )
                return Parser.setError( "repetitions already defined" );
            if( ( nRet = Parser.readToken() ) != OK ||
                ( nRet = Parser.scanInteger( m_nRepetitions, 1 ) ) != OK ) {
                return nRet;
            }
            I.m_bParam3 = true;
            break;

        default :
            return super::parseParam( Parser, Info );
    }

    return OK;
}


//
//   t S h o c k S c e n a r i o
//

tShockScenario::tShockScenario()

{
    init();
}


//
//   t S h o c k S c e n a r i o
//

tShockScenario::tShockScenario( const tShockScenario& Shock )

{
    init();
    copyFrom( Shock );
}


//
//   ~ t S h o c k S c e n a r i o
//

tShockScenario::~tShockScenario()

{
    reset();
}


//
//   r e s e t
//

void tShockScenario::reset()

{
    m_nDuration = 1;
    m_nPeriodicity = 1;
    m_nRepetitions = 1;

    super::reset();
}


//
//   o p e r a t o r =
//

tShockScenario& tShockScenario::operator=( const tShockScenario& Shock )

{
    if( &Shock != this )
        copyFrom( Shock );
    return *this;
}


//
//   c o p y F r o m
//

void tShockScenario::copyFrom( const tShockScenario& Shock )

{
    if( &Shock == this )
        return;

    reset();

    m_nDuration = Shock.m_nDuration;
    m_nPeriodicity = Shock.m_nPeriodicity;
    m_nRepetitions = Shock.m_nRepetitions;

    super::copyFrom( Shock );  // Copy m_bFinalized last!
}


//
//   c l o n e
//

tObject* tShockScenario::clone() const

{
    return new tShockScenario( *this );
}


//
//   g e t E v G e n e r a t o r
//

tEvGenerator* tShockScenario::getEvGenerator( int nMaturity ) const

{
    tSeqEvGenerator* pEvGen = new tSeqEvGenerator;

    int d = m_nPeriodicity;

    if( m_nDuration < nMaturity )
        *pEvGen += m_nDuration;

    while( d < nMaturity ) {
        *pEvGen += d;
        if( d + m_nDuration < nMaturity )
            *pEvGen += d + m_nDuration;
        d += m_nPeriodicity;
    }

    return pEvGen;
}


//
//   f i n a l i z e
//

tRetCode tShockScenario::finalize()

{
    return super::finalize();
}

MTG_END_NAMESPACE