// Copyright 1999, 2002 Robert Buff
// Contact: http://robertbuff.com/uvm
//
// This file is part of Mtg-Book.
//
// Mtg-Book is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2 of the License,
// or (at your option) any later version.
//
// Mtg-Book is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Mtg-Book; if not, write to the 
//
// Free Software Foundation, Inc.
// 59 Temple Place, Suite 330
// Boston, MA 02111-1307
// USA

#include "MtgIncl.h"
#include "MtgShortRateEngine.h"
#include "MtgShortRateModel.h"
#include "MtgPathSpace.h"

MTG_BEGIN_NAMESPACE


//
//   i n i t
//

void tShortRateEngine::init()

{
}


//
//   b e f o r e R u n
//

tRetCode tShortRateEngine::beforeRun()

{
    tRetCode nRet;
    
    if( ( nRet = super::beforeRun() ) != OK )
        return nRet;

    static_cast<tDateBase&>( m_TermStruct ) = pathSpace();
    return OK;
}


//
//   a f t e r R u n
//

tRetCode tShortRateEngine::afterRun()

{
    return super::afterRun();
}


//
//   p r e p a r e P a t h
//

tRetCode tShortRateEngine::preparePath()

{
    tRetCode nRet;

        // assume that the whatever model has created a
        // evolution structure that contains a evolution
        // substructure based on
        // tShortRateTermStruct::tEvolutionStub,
        // and simulate a cross-cast

    tShortRateModel::tEvolution* pEvolution =
        dynamic_cast<tShortRateModel::tEvolution*>( &evolution() );
    MTG_ASSERT( pEvolution != 0 );

    if( ( nRet = m_TermStruct.finalize( pEvolution->proxy() ) ) != OK )
        return nRet;

    return OK;
}


//
//   t S h o r t R a t e E n g i n e
//

tShortRateEngine::tShortRateEngine()

{
    init();
}


//
//   ~ t S h o r t R a t e E n g i n e
//

tShortRateEngine::~tShortRateEngine()

{
}


//
//   d a t e B a s e
//

const tDateBase& tShortRateEngine::dateBase() const

{
    return pathSpace();
}


//
//   d a t e R a n g e
//

const tDateRange& tShortRateEngine::dateRange() const

{
    return pathSpace();
}


//
//   f o r w a r d
//

double tShortRateEngine::forward( double gFromDay, double gToDay ) const

{
    if( m_TermStruct.scale() != xDay )
        throw tException( NOT_AVAILABLE );

    if( ! m_TermStruct.isCoveredTU( gFromDay ) ||
        ! m_TermStruct.isCoveredTU( gToDay ) ) {
        throw tException( OUT_OF_RANGE );
    }

    return m_TermStruct.forwardTU( gFromDay, gToDay );
}


//
//   f o r w a r d
//

double tShortRateEngine::forward( tDate Start, tDate End ) const

{
    if( ! m_TermStruct.isCovered( Start ) ||
        ! m_TermStruct.isCovered( End ) ) {
        throw tException( OUT_OF_RANGE );
    }

    return m_TermStruct.forward( Start, End );
}


//
//   p r e s e n t V a l u e
//

double tShortRateEngine::presentValue( double gFromDay, double gToDay ) const

{
    if( m_TermStruct.scale() != xDay )
        throw tException( NOT_AVAILABLE );

    if( ! m_TermStruct.isCoveredTU( gFromDay ) ||
        ! m_TermStruct.isCoveredTU( gToDay ) ) {
        throw tException( OUT_OF_RANGE );
    }

    return m_TermStruct.presentValueTU( gFromDay, gToDay );
}


//
//   f u t u r e V a l u e
//

double tShortRateEngine::futureValue( double gFromDay, double gToDay ) const

{
    if( m_TermStruct.scale() != xDay )
        throw tException( NOT_AVAILABLE );

    if( ! m_TermStruct.isCoveredTU( gFromDay ) ||
        ! m_TermStruct.isCoveredTU( gToDay ) ) {
        throw tException( OUT_OF_RANGE );
    }

    return m_TermStruct.futureValueTU( gFromDay, gToDay );
}


//
//   p r e s e n t V a l u e
//

double tShortRateEngine::presentValue( tDate Start, tDate End ) const

{
    if( ! m_TermStruct.isCovered( Start ) ||
        ! m_TermStruct.isCovered( End ) ) {
        throw tException( OUT_OF_RANGE );
    }

    return m_TermStruct.presentValue( Start, End );
}


//
//   f u t u r e V a l u e
//

double tShortRateEngine::futureValue( tDate Start, tDate End ) const

{
    if( ! m_TermStruct.isCovered( Start ) ||
        ! m_TermStruct.isCovered( End ) ) {
        throw tException( OUT_OF_RANGE );
    }

    return m_TermStruct.futureValue( Start, End );
}


//
//   f o r w a r d S I
//

double tShortRateEngine::forwardSI( double gFromSub, double gToSub ) const

{
    if( ! m_TermStruct.isCoveredSI( gFromSub ) ||
        ! m_TermStruct.isCoveredSI( gToSub ) ) {
        throw tException( OUT_OF_RANGE );
    }

    return m_TermStruct.forwardSI( gFromSub, gToSub );
}


//
//   p r e s e n t V a l u e S I
//

double tShortRateEngine::presentValueSI( double gFromSub, double gToSub ) const

{
    if( ! m_TermStruct.isCoveredSI( gFromSub ) ||
        ! m_TermStruct.isCoveredSI( gToSub ) ) {
        throw tException( OUT_OF_RANGE );
    }

    return m_TermStruct.presentValueSI( gFromSub, gToSub );
}


//
//   f u t u r e V a l u e S I
//

double tShortRateEngine::futureValueSI( double gFromSub, double gToSub ) const

{
    if( ! m_TermStruct.isCoveredSI( gFromSub ) ||
        ! m_TermStruct.isCoveredSI( gToSub ) ) {
        throw tException( OUT_OF_RANGE );
    }

    return m_TermStruct.futureValueSI( gFromSub, gToSub );
}

MTG_END_NAMESPACE
