// Copyright 1999, 2002 Robert Buff
// Contact: http://robertbuff.com/uvm
//
// This file is part of Mtg-Book.
//
// Mtg-Book is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2 of the License,
// or (at your option) any later version.
//
// Mtg-Book is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Mtg-Book; if not, write to the 
//
// Free Software Foundation, Inc.
// 59 Temple Place, Suite 330
// Boston, MA 02111-1307
// USA

#if ! defined(_MTG_SHORT_RATE_MODEL_)
#define _MTG_SHORT_RATE_MODEL_

#include "MtgHeap.h"
#include "MtgMCEngine.h"
#include "MtgModel.h"
#include "MtgShortRateTermStruct.h"

MTG_BEGIN_NAMESPACE

class tBootstrap;
class tDateBase;
class tDrift;
class tParser;


//
//   t V a s i c e k M o d e l
//

class tShortRateModel : public tModel {

    typedef tModel super;

public:

        // evolution class for ShortRate model:

    class tEvolution :
        public tMCEngine::tEvolutionStub
        /* public tShortRateTermStruct::tEvolutionStub */ {

    protected:

        const tShortRateModel& m_Model;
        const tPathSpace& m_PathSpace;

        double m_gInitial;

    public:

        tEvolution( const tShortRateModel& Model,
            const tPathSpace& PathSpace );

                // simulate a cross cast:

        virtual tShortRateTermStruct::tEvolutionStub& proxy() = 0;
    };

private:
        // The initial short rate r_0 can be obtained in many
        // ways: directly (in m_gInitial), or indirectly,
        // through a bootstrap or drift object. If a bootstrap
        // object is used, interest conventions must be supplied
        // to the evolution constructor.

    tBootstrap* m_pInitialBoot;  // reference
    tDrift* m_pInitialDrift;     // reference

    double m_gInitial;

    void init();

    friend class tEvolution;

protected:

    void copyFrom( const tShortRateModel& Model );

    tRetCode parseParam( tParser& Parser, tParseInfoStub& Info );
    tRetCode parsePostfix( tParser& Parser, tParseInfoStub& Info );

public:

    tShortRateModel();
    tShortRateModel( const tShortRateModel& Model );

    ~tShortRateModel();

    tRetCode finalize();

    tRetCode createEngine( tMCEngine*& pEngine );
};

MTG_END_NAMESPACE

#endif
