// Copyright 1999, 2002 Robert Buff
// Contact: http://robertbuff.com/uvm
//
// This file is part of Mtg-Book.
//
// Mtg-Book is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2 of the License,
// or (at your option) any later version.
//
// Mtg-Book is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Mtg-Book; if not, write to the 
//
// Free Software Foundation, Inc.
// 59 Temple Place, Suite 330
// Boston, MA 02111-1307
// USA

#include "MtgIncl.h"

#define _MTG_SIG_ASSOC_BODY_
#include "MtgSigAssoc.h"
#undef _MTG_SIG_ASSOC_BODY_

MTG_BEGIN_NAMESPACE


//
//   i n i t
//

template <class T>
void tSigAssoc<T>::init()

{
    reset();
}


//
//   g e t G r o u p
//

template <class T>
tSigAssoc<T>::tGroup& tSigAssoc<T>::getGroup( int nTag )

{
    MTG_ASSERT( nTag >= 0 );

    if( nTag >= m_Group.numOfElems() ) {
        int k = m_Group.numOfElems();

        m_Group.numOfElems( nTag + 1 );
        while( k <= nTag )
            m_Group[k++] = 0;
    }

    if( m_Group[nTag] == 0 ) {
        m_Group[nTag] = new tGroup;

        tGroup& G = *m_Group[nTag];

        G.m_Index.numOfElems( 1 );
        G.m_Index[0] = G.m_Index0;
        memset( G.m_Index0, 0, sizeof(G.m_Index0) );
    }

    return *m_Group[nTag];
}


//
//   t S i g A s s o c
//

template <class T>
tSigAssoc<T>::tSigAssoc()

{
    init();
}


//
//   t S i g A s s o c
//

template <class T>
tSigAssoc<T>::tSigAssoc( const tSigAssoc& Assoc )

{
    init();
    copyFrom( Assoc );
}


//
//   ~ t S i g A s s o c
//

template <class T>
tSigAssoc<T>::~tSigAssoc()

{
    reset();
}


//
//   r e s e t
//

template <class T>
void tSigAssoc<T>::reset()

{
    for( int k = 0; k < m_Group.numOfElems(); ++k ) {
        if( m_Group[k] != 0 ) {
            tGroup& G = *m_Group[k];

            for( int i = 0; i < G.m_Entry.numOfElems(); ++i )
                delete G.m_Entry[i].m_pSig;
            G.m_Entry.reset();

            for( int j = 1; j < G.m_Index.numOfElems(); ++j )
                delete[] G.m_Index[j];
            G.m_Index.reset();

            delete m_Group[k];
        }
    }
    m_Group.reset();
    m_nNumOfSigs = 0;
}


//
//   o p e r a t o r =
//

template <class T>
tSigAssoc<T>& tSigAssoc<T>::operator=( const tSigAssoc<T>& Assoc )

{
    if( &Assoc != this )
        copyFrom( Assoc );
    return *this;
}


//
//   c o p y F r o m
//

template <class T>
void tSigAssoc<T>::copyFrom( const tSigAssoc<T>& Assoc )

{
    if( &Assoc == this )
        return;

    reset();

    m_nNumOfFlags = Assoc.m_nNumOfFlags;

    for( int k = 0; k < Assoc.m_Group.numOfElems(); ++k ) {
        if( Assoc.m_Group[k] != 0 ) {
            tGroup& G1 = *Assoc.m_Group[k];
            tGroup& G2 = getGroup( k );
            
            G2.m_Entry.copyFrom( G1.m_Entry );
            for( int i = 0; i < G2.m_Entry.numOfElems(); ++i )
                G2.m_Entry[i].m_pSig = G2.m_Entry[i].m_pSig->clone();

            G2.m_Index.numOfElems( G1.m_Index.numOfElems() );
            memcpy( G2.m_Index0, G1.m_Index0, sizeof(G1.m_Index0) );
            for( MTG_FOR_INIT( int ) i = 1;
                    i < G1.m_Index.numOfElems(); ++i ) {
                G2.m_Index[i] = new int[256];
                memcpy( G2.m_Index[i], G1.m_Index[i], sizeof(G1.m_Index0) );
            }
        }
    }
}


//
//   i n s e r t
//

template <class T>
tRetCode tSigAssoc<T>::insert( const tSignature& Sig, int nTag, T& Data )

{
    int nPos;
    size_t i, k, k1;

    if( m_nNumOfSigs == 0 )
        m_nNumOfFlags = Sig.numOfFlags();
    else
        MTG_ASSERT( Sig.numOfFlags() == m_nNumOfFlags );

    tGroup& G = getGroup( nTag );

    for( i = k = 0; i < Sig.size() - 1; ++i ) {
        k1 = G.m_Index[k][Sig.flag( i )];
        MTG_ASSERT( k1 >= 0 && (int) k1 < G.m_Index.numOfElems() );

        if( k1 == 0 ) {
            k1 = G.m_Index.numOfElems();
            ++G.m_Index;
            G.m_Index[k1] = new int[256];
            memset( G.m_Index[k1], 0, sizeof(G.m_Index0) );
            G.m_Index[k][Sig.flag( i )] = k1;
        }
        k = k1;
    }

    k1 = G.m_Index[k][Sig.flag( Sig.size() - 1 )];

    if( k1 == 0 ) {
        nPos = G.m_Entry.numOfElems();

        ++G.m_Entry;
        G.m_Entry[nPos].m_pSig = Sig.clone();
        G.m_Index[k][Sig.flag( Sig.size() - 1 )] = nPos + 1;

        ++m_nNumOfSigs;
    }
    else {
        nPos = k1 - 1;
        MTG_ASSERT( nPos < G.m_Entry.numOfElems() );
    }

    G.m_Entry[nPos].m_Data = Data;
    return OK;
}


//
//   r e t r i e v e
//

template <class T>
tRetCode tSigAssoc<T>::retrieve( const tSignature& Sig, int nTag, T& Data )

{
    size_t i, k;        

    if( nTag < 0 || nTag >= m_Group.numOfElems() || m_Group[nTag] == 0 )
        return NOT_FOUND;

    tGroup& G = *m_Group[nTag];

    for( i = k = 0; i < Sig.size() - 1; ++i ) {
        if( ( k = G.m_Index[k][Sig.flag( i )] ) == 0 )
            return NOT_FOUND;
    }

    if( ( k = G.m_Index[k][Sig.flag( Sig.size() - 1 )] ) == 0 )
        return NOT_FOUND;

    Data = G.m_Entry[(int) k - 1].m_Data;
    return OK;
}

#if ! defined(_MTG_SIG_ASSOC_HEADER_)

//#define _TEST
#if defined(_TEST)

#include <conio.h>

//
//   m a i n
//

void main( int argc, char *argv[] )

{
    bool bGo;
    int k, cCmd, nRet, nData, nTag, nNumOfFlags;
    char sFlags[128];
    tSignature Sig;
    tSigAssoc<int> SigAssoc;

    printf( "\nTest tSigAssoc\n\n" );

    nNumOfFlags = 16;

    bGo = true;
    while( bGo ) {
        printf( "<C>lear <I>nsert <R>etrieve E<x>it: " );
        cCmd = getche();
        printf( "\n" );

        nRet = OK;
        switch( cCmd ) {
            case 'c' :
            case 'C' :
                printf( "   NumOfFlags: " );
                scanf( "%d", &nNumOfFlags );
                SigAssoc.reset();
                break;

            case 'i' :
            case 'I' :
                printf( "  Flags%d Data Tag: ", nNumOfFlags );
                scanf( "%s%d%d", sFlags, &nData, &nTag );
                Sig.reset( nNumOfFlags );
                for( k = 0; sFlags[k] != 0 && k < nNumOfFlags; ++k ) {
                    if( sFlags[k] == '1' )
                        Sig.on( k );
                }
                Sig.setTag( nTag );
                nRet = SigAssoc.insert( Sig, nData );
                break;

            case 'r' :
            case 'R' :
                printf( "  Flags%d Tag: ", nNumOfFlags );
                scanf( "%s%d", sFlags, &nTag );
                Sig.reset( nNumOfFlags );
                for( k = 0; sFlags[k] != 0 && k < nNumOfFlags; ++k ) {
                    if( sFlags[k] == '1' )
                        Sig.on( k );
                }
                Sig.setTag( nTag );
                nRet = SigAssoc.retrieve( Sig, nData );
                if( nRet == OK )
                    printf( "  Data=%d\n", nData );
                break;

            case 'x' :
            case 'X' :
                bGo = false;
                break;
        }

        if( nRet != OK )
            printf( "  Error=%d\n", nRet );
    }
}

#endif

#endif

MTG_END_NAMESPACE
