// Copyright 1999, 2002 Robert Buff
// Contact: http://robertbuff.com/uvm
//
// This file is part of Mtg-Book.
//
// Mtg-Book is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2 of the License,
// or (at your option) any later version.
//
// Mtg-Book is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Mtg-Book; if not, write to the 
//
// Free Software Foundation, Inc.
// 59 Temple Place, Suite 330
// Boston, MA 02111-1307
// USA

#if ! defined(_MTG_SQ_TERM_STRUCT_)
#define _MTG_SQ_TERM_STRUCT_

#include "MtgTermStruct.h"

MTG_BEGIN_NAMESPACE

    
//
//   t S q T e r m S t r u c t
//
    
class tSqTermStruct : public tTermStruct {

        // Regarding tSpec: m_Imp2 contains the sum of the squared
        // values of all forward volatilities up to and including
        // time unit m_nUnit. m_Fwd2 contains the squared components of
        // m_Fwd, to speed up computation. So in order to
        // get the implied volatility for unit t, one has to compute
        // sqrt( ( m_Imp2 + ( t - m_nUnit ) * m_Fwd2 ) / ( t + 1 ) ).

        // If volatility data is requested beyond the maturity of the
        // term structure, the forward vol m_Fwd of the last unit of
        // the term structure is simply regarded as the forward vol
        // of any additional unit after the maturity date as well,
        // and the computations are done accordingly.

    tRetCode calcFwd( int nMaturity1, double gImp1,
        int nMaturity2, double gImp2, double& gFwd ) const;

    tRetCode testImp( double gImp ) const;
    tRetCode testFwd( double gFwd ) const;

    void trim( double& gFwd ) const;
    double scaleUp( double gFwd ) const;
    double scaleDown( double gFwd ) const;
  
public:

};

MTG_END_NAMESPACE

#endif
