// Copyright 1999, 2002 Robert Buff
// Contact: http://robertbuff.com/uvm
//
// This file is part of Mtg-Book.
//
// Mtg-Book is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2 of the License,
// or (at your option) any later version.
//
// Mtg-Book is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Mtg-Book; if not, write to the 
//
// Free Software Foundation, Inc.
// 59 Temple Place, Suite 330
// Boston, MA 02111-1307
// USA

#if ! defined(_MTG_STEP_DRIFT_)
#define _MTG_STEP_DRIFT_

#include "MtgDrift.h"
#include "MtgLinTermStruct.h"

MTG_BEGIN_NAMESPACE

class tBootstrap;
class tCurve;
class tInterestSpline;


//
//   t S t e p D r i f t
//

class tStepDrift : public tDrift { 

    typedef tDrift super;

    tLinTermStruct m_TermStruct;

        // while parsing, store here which objects we're adding:

    tHeap<tObject*> m_AddOther;

    void cleanup();
    void copyFrom( const tStepDrift& Drift );

    tRetCode parseParam( tParser& Parser, tParseInfoStub& Info );
    tRetCode parsePostfix( tParser& Parser, tParseInfoStub& Info );

public:

    tStepDrift();

        // Passed on to the tDrift constructor (see tDateBase.h
        // for changing the values manually):

    tStepDrift( tScale nScale );
    tStepDrift( tScale nScale, int nNumOfPeriods );
    tStepDrift( tScale nScale, const tDayCount& DayCount );
    tStepDrift( tScale nScale, int nNumOfPeriods,
        const tDayCount& DayCount );
    tStepDrift( tScale nScale, const tDayCount& DayCount,
        tDate Base );
    tStepDrift( tScale nScale, int nNumOfPeriods,
        const tDayCount& DayCount, tDate Base );

    tStepDrift( const tStepDrift& Drift );

    ~tStepDrift();

        // Complete assignment, including date base:
        
    tStepDrift& operator=( const tStepDrift& Drift );
    tStepDrift& operator=( const tLinTermStruct& TS );

    tObject* clone() const;

        // Some operations of tTermStruct are offered
        // on this level. If others are desired, the
        // term structure needs to be assembled outside
        // and passed to the drift object via assigment.

    tRetCode addForward( int nMaturity, double gFwd );
    tRetCode addImplied( int nMaturity, double gImp );

        // Additive, not changing date base (elements
        // before the base date are ignored):

    tRetCode addSpline( tInterestSpline& Spline );
    tRetCode addBootstrap( tBootstrap& Boot );
    tRetCode addCurve( const tCurve& Curve );
    tRetCode addDrift( const tDrift& Drift );

        // All requests are simply forwarded to the
        // term structure object. Note that all these
        // operations have to pass through the drift
        // object, as the finalization flag needs to
        // be maintained in it.

    tRetCode operator-=( const tDrift& Drift );
    tRetCode operator^=( const tDrift& Drift );

        // Note that finalize() must be called before
        // any of the retrieval functions can.

    tRetCode finalize();

    void getFwdRange( double& gMin, double& gMax ) const {
        m_TermStruct.getFwdRange( gMin, gMax );
    }

        // All retrieval is based on the term structure.

    double forwardSI( int nSub ) const {
        return m_TermStruct.forward( nSub );
    }

    double forwardSI( int nFromSub, int nToSub ) const {
        return m_TermStruct.forward( nFromSub, nToSub );
    }

    double forwardSI( double gFromSub, double gToSub ) const {
        return m_TermStruct.forward( gFromSub, gToSub );
    }

    double impliedSI( int nMaturity ) const {
        return m_TermStruct.implied( nMaturity );
    }

    int constantUntil() const {
        return m_TermStruct.constantUntil();
    }

    int maturity() const {
        return m_TermStruct.maturity();
    }
};

MTG_END_NAMESPACE

#endif
