// Copyright 1999, 2002 Robert Buff
// Contact: http://robertbuff.com/uvm
//
// This file is part of Mtg-Book.
//
// Mtg-Book is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2 of the License,
// or (at your option) any later version.
//
// Mtg-Book is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Mtg-Book; if not, write to the 
//
// Free Software Foundation, Inc.
// 59 Temple Place, Suite 330
// Boston, MA 02111-1307
// USA

#include "MtgIncl.h"
#include "MtgStepVol.h"
#include "MtgParser.h"

MTG_BEGIN_NAMESPACE


//
//   p a r s e P a r a m
//

tRetCode tStepVol::parseParam( tParser& Parser, tParseInfoStub& Info )

{
    tRetCode nRet;
    tParseInfo& I = static_cast<tParseInfo&>( Info );

    nRet = m_PriorTermStruct.parseParam( Parser, I.m_gPlusBand, 
            I.m_gMinusBand, &m_MinTermStruct, &m_MaxTermStruct );
    
    if( nRet == GO )
        nRet = super::parseParam( Parser, Info );

    touch();
    return nRet;
}


//
//   p a r s e P o s t f i x
//

tRetCode tStepVol::parsePostfix( tParser& Parser, tParseInfoStub& Info )

{
    tRetCode nRet;
    tParseInfo& I = static_cast<tParseInfo&>( Info );

    if( ( nRet = m_PriorTermStruct.parsePostfix( Parser, I.m_gPlusBand, 
                    I.m_gMinusBand, &m_MinTermStruct,
                    &m_MaxTermStruct ) ) != OK ) {
        return nRet;
    }
    return super::parsePostfix( Parser, Info );
}


//
//   t S t e p V o l
//

tStepVol::tStepVol()

{
}


//
//   t S t e p V o l
//

tStepVol::tStepVol( const tStepVol& Vol )

{
    copyFrom( Vol );
}


//
//   ~ t S t e p V o l
//

tStepVol::~tStepVol()

{
}


//
//   o p e r a t o r =
//

tStepVol& tStepVol::operator=( const tStepVol& Vol )

{
    if( this != &Vol )
        copyFrom( Vol );
    return *this;
}


//
//   c o p y F r o m
//

void tStepVol::copyFrom( const tStepVol& Vol )

{
    if( this == &Vol )
        return;

    m_PriorTermStruct = Vol.m_PriorTermStruct;
    m_MaxTermStruct = Vol.m_MaxTermStruct;
    m_MinTermStruct = Vol.m_MinTermStruct;

    super::copyFrom( Vol );
}


//
//   f i n a l i z e
//

tRetCode tStepVol::finalize()

{
    MTG_ASSERT( m_MinTermStruct <= m_PriorTermStruct &&
                m_PriorTermStruct <= m_MaxTermStruct );

    tRetCode nRet;

    if( isFinalized() )
        return OK;

    if( ( nRet = m_PriorTermStruct.finalize() ) != OK ||
        ( nRet = m_MinTermStruct.finalize() ) != OK ||
        ( nRet = m_MaxTermStruct.finalize() ) != OK ) {
        return nRet;
    }

    m_nMaturity = m_PriorTermStruct.maturity();
    if( m_MinTermStruct.maturity() > m_nMaturity )
        m_nMaturity = m_MinTermStruct.maturity();
    if( m_MaxTermStruct.maturity() > m_nMaturity )
        m_nMaturity = m_MaxTermStruct.maturity();

    m_nCertainAfter = m_PriorTermStruct.certainAfter( m_MinTermStruct );
    int t = m_PriorTermStruct.certainAfter( m_MaxTermStruct );
    if( t > m_nCertainAfter )
        m_nCertainAfter = t;

    m_nCertainUntil = m_PriorTermStruct.certainUntil( m_MinTermStruct );
    t = m_PriorTermStruct.certainUntil( m_MaxTermStruct );
    if( t < m_nCertainUntil )
        m_nCertainUntil = t;

    m_nConstantUntil = m_nCertainUntil;
    if( m_PriorTermStruct.constantUntil() < m_nConstantUntil )
        m_nConstantUntil = m_PriorTermStruct.constantUntil();

    return super::finalize();
}


//
//   g e t F w d R a n g e
//

void tStepVol::getFwdRange( double& gMin, double& gMax ) const

{
    double t;

    m_MinTermStruct.getFwdRange( gMin, t );
    m_MaxTermStruct.getFwdRange( t, gMax );
}


//
//   f o r w a r d
//

void tStepVol::forward( int nUnit, double& gMin, double& gMax ) const

{
    gMin = m_MinTermStruct.forward( nUnit );
    gMax = m_MaxTermStruct.forward( nUnit );
}


//
//   f o r w a r d
//

void tStepVol::forward( int nFromUnit, int nToUnit, double& gMin,
    double& gMax ) const

{
    gMin = m_MinTermStruct.forward( nFromUnit, nToUnit );
    gMax = m_MaxTermStruct.forward( nFromUnit, nToUnit );
}


//
//   i m p l i e d
//

void tStepVol::implied( int nMaturity, double& gMin, double& gMax ) const

{
    gMin = m_MinTermStruct.implied( nMaturity );
    gMax = m_MaxTermStruct.implied( nMaturity );
}


//
//   f w d
//

void tStepVol::forward( int nUnit, double& gPrior, double& gMin,
    double& gMax ) const

{
    gPrior = m_PriorTermStruct.forward( nUnit );
    gMin = m_MinTermStruct.forward( nUnit );
    gMax = m_MaxTermStruct.forward( nUnit );
}


//
//   f o r w a r d
//

void tStepVol::forward( int nFromUnit, int nToUnit, double& gPrior,
    double& gMin, double& gMax ) const

{
    gPrior = m_PriorTermStruct.forward( nFromUnit, nToUnit );
    gMin = m_MinTermStruct.forward( nFromUnit, nToUnit );
    gMax = m_MaxTermStruct.forward( nFromUnit, nToUnit );
}


//
//   i m p l i e d
//

void tStepVol::implied( int nMaturity, double& gPrior,
    double& gMin, double& gMax ) const

{
    gPrior = m_PriorTermStruct.implied( nMaturity );
    gMin = m_MinTermStruct.implied( nMaturity );
    gMax = m_MaxTermStruct.implied( nMaturity );
}


//
//   c l o n e
//

tObject* tStepVol::clone() const

{
    return new tStepVol( *this );
}

MTG_END_NAMESPACE