// Copyright 1999, 2002 Robert Buff
// Contact: http://robertbuff.com/uvm
//
// This file is part of Mtg-Book.
//
// Mtg-Book is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2 of the License,
// or (at your option) any later version.
//
// Mtg-Book is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Mtg-Book; if not, write to the 
//
// Free Software Foundation, Inc.
// 59 Temple Place, Suite 330
// Boston, MA 02111-1307
// USA

#if ! defined(_MTG_TCL_KERNEL_)
#define _MTG_TCL_KERNEL_

#if defined(_MTG_WITH_TCL)

#include "MtgHeap.h"

#include <tcl.h>
#include <tk.h>

MTG_BEGIN_NAMESPACE


//
//   t T c l K e r n e l
//

class tTclKernel {

        // The Tcl interpreter:

    Tcl_Interp* m_pInterp;  

    static bool m_bInitialized;
    static bool m_bInteractive;

    void create();
    void cleanup();

    void showError();

        // A Tcl kernel cannot be copied or assigned:

    tTclKernel( const tTclKernel& Kernel ) {
        throw tException( INTERNAL_ERROR );
    }

    tTclKernel& operator=( const tTclKernel& Kernel ) {
        throw tException( INTERNAL_ERROR );
        return *this;
    }

        // Tcl commands:

    #define MTG_DECLARE_CMD( f ) \
        static int f( ClientData ClientData, Tcl_Interp *pInterp, \
            int objc, Tcl_Obj *CONST objv[] );

    MTG_DECLARE_CMD( system )
    MTG_DECLARE_CMD( fork )
    MTG_DECLARE_CMD( tclify )
    MTG_DECLARE_CMD( lock )
    MTG_DECLARE_CMD( unlock )

    #undef MTG_DECLARE_CMD

public:

        // This function must be called before any Tcl kernel
        // is allocated:

    static void init( const char* sExecutable, bool bInteractive );
    static void exit();

    tTclKernel();
    ~tTclKernel();

    tRetCode useArgs( int& argc, const char* argv[] );

    void setArgs( int argc, const char* argv[] );
    void setVar( const char* sName, const char* sValue );

    tRetCode runFile( const char* sFileName );
    tRetCode runFile( int argc, const char* argv[] );

    tRetCode runBatch( const char* sFileMask, bool bIgnoreError = false );

    bool isOpen() const {
        return m_pInterp != 0;
    }

    Tcl_Interp* interp() {
        MTG_ASSERT( isOpen() );
        return m_pInterp;
    }

        // Frees the interpreter prematurely:

    void close();
};

MTG_END_NAMESPACE

#endif

#endif
