// Copyright 1999, 2002 Robert Buff
// Contact: http://robertbuff.com/uvm
//
// This file is part of Mtg-Book.
//
// Mtg-Book is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2 of the License,
// or (at your option) any later version.
//
// Mtg-Book is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Mtg-Book; if not, write to the 
//
// Free Software Foundation, Inc.
// 59 Temple Place, Suite 330
// Boston, MA 02111-1307
// USA

#if ! defined(_MTG_TIME_AXIS_)
#define _MTG_TIME_AXIS_

#include "MtgHeap.h"
#include "MtgEvGenerator.h"
#include "MtgDtGenerator.h"

MTG_BEGIN_NAMESPACE

class tSpaceAxis;
class tPortfolio;


//
//   t T i m e A x i s
//

class tTimeAxis {

    struct tSlice {
        int m_nDay;
        double m_gFractionOfDay;
    };

        // These pointers are only used during finalization; at other
        // times, they may be dangling. The objects are not owned.

    tHeap<tSpaceAxis*>* m_pSpace;
    tEvGenerator* m_pEvGen;   
    tDtGenerator* m_pDtGen;   

    const tPortfolio* m_pPf;

        // Can be used to override the portfolio event trace (the
        // larger is chosen). Either this, or the portfolio pointer,
        // or the event generator has to be present.

    int m_nMaturity;
    double m_gStableDt;

    tHeap<tSlice> m_aSlice;

    bool m_bFinalized;

    void init();

    void addSlice( int nDay, tDtGenerator& DtGen );

public:

    tTimeAxis();
    tTimeAxis( const tTimeAxis& Axis );

    ~tTimeAxis();

    void reset();

    tTimeAxis& operator=( const tTimeAxis& Axis );

    void copyFrom( const tTimeAxis& Axis );

    tTimeAxis* clone() const;

    void setSpaceAxis( tHeap<tSpaceAxis*>& Space );
    void setSpaceAxis( tHeap<tSpaceAxis*>* pSpace = 0 );

    void setEvGenerator( tEvGenerator& EvGen );
    void setEvGenerator( tEvGenerator* pEvGen = 0 );

    void setDtGenerator( tDtGenerator& DtGen );
    void setDtGenerator( tDtGenerator* pDtGen = 0 );

    void setPortfolio( const tPortfolio& Pf );
    void setPortfolio( const tPortfolio* pPf = 0 );

    void setMaturity( int nMaturity );

    void finalize();

    tRetCode beforeRun();

    int numOfSlices() const {
        return m_aSlice.numOfElems();
    }

    double stableDt() const {
        return m_gStableDt;
    }

    int day( int nSlice ) const {
        return m_aSlice[nSlice].m_nDay;
    }

    double fractionOfDay( int nSlice ) const {
        return m_aSlice[nSlice].m_gFractionOfDay;
    }

    double absDuration( int nSlice ) const;
    double relDuration( int nSlice ) const;
};

MTG_END_NAMESPACE

#endif
