// Copyright 1999, 2002 Robert Buff
// Contact: http://robertbuff.com/uvm
//
// This file is part of Mtg-Book.
//
// Mtg-Book is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2 of the License,
// or (at your option) any later version.
//
// Mtg-Book is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Mtg-Book; if not, write to the 
//
// Free Software Foundation, Inc.
// 59 Temple Place, Suite 330
// Boston, MA 02111-1307
// USA

#include "MtgIncl.h"
#include "MtgToken.h"

MTG_BEGIN_NAMESPACE


//
//   T e x t 2 T o k e n
//

tToken Text2Token( const char* sText )

{
    static struct {
        char *m_sName;
        tToken m_nType;
    } IdTable[] = {
        { "accrual_factor", xTokAccrualFactor },
        { "accuracy", xTokAccuracy },
        { "act_360", xTokACT_360 },
        { "act_365", xTokACT_365 },
        { "act_365_25", xTokACT_365_25 },
        { "act_365_isda", xTokACT_365_ISDA },
        { "act_365_nl", xTokACT_365_NL },
        { "act_act", xTokACT_ACT },
        { "alpha", xTokAlpha },
        { "american", xTokMonitor },
        { "american_call", xTokAmericanCall },
        { "american_put", xTokAmericanPut },
        { "ask", xTokAskPrice },
        { "ask_price", xTokAskPrice },
        { "at", xTokAt },
        { "band", xTokBand },
        { "base", xTokBase },
        { "bid", xTokBidPrice },
        { "bid_price", xTokBidPrice },
        { "binary", xTokDigital },
        { "birth", xTokBirth },
        { "black_scholes", xTokBlackScholes },
        { "blue", xTokBlue },
        { "bond", xTokUSTBond },
        { "bootstrap", xTokBootstrap },
        { "boundary", xTokPayoff },
        { "box", xTokBox },
        { "bs", xTokBlackScholes },
        { "buy", xTokBuyer },
        { "buyer", xTokBuyer },
        { "bye", xTokEOF },
        { "cal", xTokCalendar },
        { "calendar", xTokCalendar },
        { "call", xTokEuropeanCall },
        { "carry", xTokCarry },
        { "cash", xTokCashflow },
        { "cashflow", xTokCashflow },
        { "cd", xTokCD },
        { "ceil", xTokCeil },
        { "claim", xTokClaim },
        { "comment", xTokComment },
        { "continuous_compounding", xTokContinuousCompounding },
        { "coupon", xTokCoupon },
        { "curve", xTokCurve },
        { "custom", xTokCustom },
        { "cutoff", xTokCutoff },
        { "day", xTokDay },
        { "day_count", xTokDayCount },
        { "days_per_year", xTokDaysPerYear },
        { "dc_30e_360", xTok30E_360 },
        { "dc_30_360_isda", xTok30_360_ISDA },
        { "dc_30_360_psa", xTok30_360_PSA },
        { "dc_30_360_sia", xTok30_360_SIA },
        { "dc_act_360", xTokACT_360 },
        { "dc_act_365", xTokACT_365 },
        { "dc_act_365_25", xTokACT_365_25 },
        { "dc_act_365_isda", xTokACT_365_ISDA },
        { "dc_act_365_nl", xTokACT_365_NL },
        { "dc_act_act", xTokACT_ACT },
        { "digital", xTokDigital },
        { "discount", xTokDiscount },
        { "discount_factor", xTokDiscountFactor },
        { "domestic", xTokDomestic },
        { "dont_exercise", xTokDontExercise },
        { "down_and_out", xTokDownAndOut },
        { "drift", xTokDrift },
        { "dt", xTokTimeStep },
        { "duration", xTokDuration },
        { "else", xTokElse },
        { "end", xTokEndif },
        { "endif", xTokEndif },
        { "entropy", xTokEntropy },
        { "european_call", xTokEuropeanCall },
        { "european_put", xTokEuropeanPut },
        { "eval", xTokEvaluate },
        { "evaluate", xTokEvaluate },
        { "event", xTokCashflow },
        { "exact", xTokExact },
        { "exercise", xTokForceExercise },
        { "exercise_payoff", xTokExercisePayoff },
        { "explicit", xTokExplicit },
        { "factor", xTokFactor },
        { "fixed", xTokFixed },
        { "floor", xTokFloor },
        { "following", xTokFollowing },
        { "force_exercise", xTokForceExercise },
        { "foreign", xTokForeign },
        { "forward", xTokForward },
        { "fraction_of_day", xTokFractionOfDay },
        { "future_value", xTokFutureValue },
        { "fwd", xTokForward },
        { "gnu_data", xTokGnuData },
        { "gnu_tics", xTokGnuTics },
        { "green", xTokGreen },
        { "high", xTokHigh },
        { "hjm_gaussian", xTokHJMGaussian },
        { "identity", xTokIdentity },
        { "if", xTokIf },
        { "image", xTokImage },
        { "imp", xTokImplied },
        { "implicit", xTokImplicit },
        { "implied", xTokImplied },
        { "import", xTokImport },
        { "include", xTokInclude },
        { "initial", xTokInitial },
        { "interest_convention", xTokInterestConvention },
        { "kappa", xTokKappa },
        { "knockout_payoff", xTokKnockoutPayoff },
        { "lambda", xTokMultiplier },
        { "lattice", xTokLattice },
        { "least_squares", xTokLeastSquares },
        { "leg", xTokLeg },
        { "linear", xTokLinear },
        { "lines", xTokLines },
        { "long", xTokLong },
        { "low", xTokLow },
        { "maturity", xTokMaturity },
        { "max", xTokMax },
        { "may_exercise", xTokMayExercise },
        { "mean", xTokMean },
        { "medium", xTokMedium },
        { "method", xTokMethod },
        { "min", xTokMin },
        { "model", xTokModel },
        { "modified", xTokModified },
        { "monitor", xTokMonitor },
        { "mtg", xTokMtg },
        { "multiplier", xTokMultiplier },
        { "on_error", xTokOnError },
        { "optimizer", xTokOptimizer },
        { "path_space", xTokPathSpace },
        { "payoff", xTokPayoff },
        { "period", xTokPeriodicity },
        { "periodicity", xTokPeriodicity },
        { "portfolio", xTokPortfolio },
        { "pos", xTokPosition },
        { "position", xTokPosition },
        { "preceding", xTokPreceding },
        { "present_value", xTokPresentValue },
        { "price", xTokPrice },
        { "principal", xTokPrincipal },
        { "put", xTokEuropeanPut },        
        { "quote", xTokQuote },
        { "red", xTokRed },
        { "repetitions", xTokRepetitions },
        { "run", xTokRun },
        { "sample", xTokSample },
        { "save", xTokSave },
        { "scale", xTokScale },
        { "scenario", xTokScenario },
        { "seed", xTokSeed },
        { "sell", xTokSeller },
        { "seller", xTokSeller },
        { "set", xTokSet },
        { "settlement", xTokSettlement },
        { "shape", xTokShape },
        { "shell", xTokShell },
        { "shock", xTokShock },
        { "short", xTokShort },
        { "sigma", xTokSigma },
        { "simple_compounding", xTokSimpleCompounding },
        { "size", xTokSize },
        { "spot", xTokSpot },
        { "steps", xTokSteps },
        { "strike", xTokStrike },
        { "system", xTokSystem },
        { "tcl", xTokTcl },
        { "then", xTokThen },
        { "theta", xTokTheta },
        { "time", xTokTime },
        { "time_step", xTokTimeStep },
        { "title", xTokTitle },
        { "tree", xTokTree },
        { "trim_dev", xTokTrimDev },
        { "try", xTokTry },
        { "type", xTokType },
        { "unit", xTokUnitValue },
        { "unit_value", xTokUnitValue },
        { "up_and_out", xTokUpAndOut },
        { "ust_bond", xTokUSTBond },
        { "value", xTokUnitValue },
        { "vasicek", xTokVasicek },
        { "verbose", xTokVerbose },
        { "vol", xTokVol },
        { "volatility", xTokVol },
        { "weight", xTokWeight },
        { "width", xTokWidth },
        { "worst_case", xTokWorstCase },
        { "year", xTokYear },
        { "yield", xTokYield },
    };

    tToken nToken = xTokId;

    int l = 0;
    int r = sizeof(IdTable) / sizeof(IdTable[0]) - 1;

    while( l <= r ) {
        int m = ( l + r ) / 2;
        int c = strcmp( sText, IdTable[m].m_sName );

        if( c < 0 ) {
            r = m - 1;
        }
        else
        if( c > 0 ) {
            l = m + 1;
        }
        else {
            nToken = IdTable[m].m_nType;
            break;
        }
    }

    return nToken;
}


//
//   T o k e n 2 T e x t
//

const char* Token2Text( tToken nToken )

{
    switch( nToken ) {
        case xTokDayCount     : return "day_count";
        case xTokACT_ACT      : return "dc_act_act";
        case xTokACT_365      : return "dc_act_365";
        case xTokACT_365_25   : return "dc_act_365_25";
        case xTokACT_365_ISDA : return "dc_act_365_isda";
        case xTokACT_365_NL   : return "dc_act_365_nl";
        case xTokACT_360      : return "dc_act_360";
        case xTok30_360_ISDA  : return "dc_30_360_isda";
        case xTok30_360_PSA   : return "dc_30_360_psa";
        case xTok30_360_SIA   : return "dc_30_360_sia";
        case xTok30E_360      : return "dc_30e_360";
        default               : break;
    }

    return "<unknown token>";
}

MTG_END_NAMESPACE
