// Copyright 1999, 2002 Robert Buff
// Contact: http://robertbuff.com/uvm
//
// This file is part of Mtg-Book.
//
// Mtg-Book is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2 of the License,
// or (at your option) any later version.
//
// Mtg-Book is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Mtg-Book; if not, write to the 
//
// Free Software Foundation, Inc.
// 59 Temple Place, Suite 330
// Boston, MA 02111-1307
// USA

#include "MtgIncl.h"

#define _MTG_TRIANGLE_BODY_
#include "MtgTriangle.h"
#undef _MTG_TRIANGLE_BODY_

MTG_BEGIN_NAMESPACE


//
//   i n i t
//

template<class T>
void tTriangle<T>::init()

{
    m_nNumOfElems = 0;
    m_nElemHiwater = 0;
    m_Data = 0;
    m_Ofs = 0;
}


//
//   r e s i z e
//

template<class T>
void tTriangle<T>::resize( int nNumOfElems )    

{
    MTG_ASSERT( nNumOfElems >= 0 );

    if( nNumOfElems > m_nElemHiwater ) {
        T* Data = new T[( nNumOfElems * ( nNumOfElems + 1 ) ) / 2];
        int* Ofs = new int[nNumOfElems];

        int k = 0;
        for( int i = 0; i < nNumOfElems; ++i ) {
            Ofs[i] = k;
            k += nNumOfElems - i;
        }

        if( m_nElemHiwater > 0 ) {
            for( int i = 0; i < m_nNumOfElems; ++i ) {
                memcpy( &Data[Ofs[i]], &m_Data[m_Ofs[i]],
                    ( m_nNumOfElems - i ) * sizeof(T) );
            }
            delete[] m_Data;
            delete[] m_Ofs;
        }

        m_Data = Data;
        m_Ofs = Ofs;
        m_nElemHiwater = nNumOfElems;
    }
}


//
//   c o p y F r o m
//

template<class T>
void tTriangle<T>::copyFrom( const tTriangle<T>& Triangle )

{
    if( &Triangle == this )
        return;

    if( m_nNumOfElems != Triangle.m_nNumOfElems ) {
        resize( Triangle.m_nNumOfElems );
        m_nNumOfElems = Triangle.m_nNumOfElems;
    }

    for( int i = 0; i < m_nNumOfElems; ++i ) {
        memcpy( &m_Data[m_Ofs[i]], &Triangle.m_Data[Triangle.m_Ofs[i]],
            ( m_nNumOfElems - i ) * sizeof(T) );
    }
}


//
//   c l e a n u p
//

template<class T>
void tTriangle<T>::cleanup()

{
    if( m_nElemHiwater > 0 ) {
        delete[] m_Data;
        delete[] m_Ofs;
        m_nElemHiwater = 0;
    }
    m_nNumOfElems = 0;
}


//
//   t T r i a n g l e
//

template<class T>
tTriangle<T>::tTriangle( int nNumOfElems )

{
    init();
    if( nNumOfElems > 0 ) 
        reset( nNumOfElems );
}


//
//   t T r i a n g l e
//

template<class T>
tTriangle<T>::tTriangle( const tTriangle<T>& Triangle )

{
    init();
    copyFrom( Triangle );
}


//
//   ~ t T r i a n g l e
//

template<class T>
tTriangle<T>::~tTriangle()

{
    cleanup();
}


//
//   r e s e t
//

template<class T>
void tTriangle<T>::reset( int nNumOfElems )

{
    resize( nNumOfElems );
    m_nNumOfElems = nNumOfElems;
}


//
//   o p e r a t o r =
//

template<class T>
tTriangle<T>& tTriangle<T>::operator=( const tTriangle<T>& Triangle )

{
    if( &Triangle != this )
        copyFrom( Triangle );
    return *this;
}

MTG_END_NAMESPACE