// Copyright 1999, 2002 Robert Buff
// Contact: http://robertbuff.com/uvm
//
// This file is part of Mtg-Book.
//
// Mtg-Book is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2 of the License,
// or (at your option) any later version.
//
// Mtg-Book is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Mtg-Book; if not, write to the 
//
// Free Software Foundation, Inc.
// 59 Temple Place, Suite 330
// Boston, MA 02111-1307
// USA

#if ! defined(_MTG_US_BOND_MATH_)
#define _MTG_US_BOND_MATH_

#include "MtgBondMath.h"

MTG_BEGIN_NAMESPACE


//
//   o b j e c t s 
//

extern class tUSBondMath USBondMath;


//
//   t U S B o n d M a t h
//

class tUSBondMath : public tBondMath {

    typedef tBondMath super;

        // This bond math calculator covers T-bills, T-bonds
        // and T-notes.

        // NOTE THAT ALL YIELD-TO_MATURITY CALCULATIONS ARE
        // BASED ON THE BOND EQUATION, NOT ON TRUE YIELD.

        // The object only prices bonds with a fixed number
        // of periods per year (default is 2):
 
    int m_nPeriods;

        // The number of periods is used in this function:

    tCompounder* createCompounder( tDate Settlement,
        tDate Maturity ) const;

    void init( int nPeriods );
    void copyFrom( const tUSBondMath& Math );

public:

    tUSBondMath();
    tUSBondMath( int nPeriods );
    tUSBondMath( const tUSBondMath& Math );

    ~tUSBondMath();

    tUSBondMath& operator=( const tUSBondMath& Math );

    friend class tUSTBond;
    friend class tUSTBill;
};

MTG_END_NAMESPACE

#endif
