// Copyright 1999, 2002 Robert Buff
// Contact: http://robertbuff.com/uvm
//
// This file is part of Mtg-Book.
//
// Mtg-Book is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2 of the License,
// or (at your option) any later version.
//
// Mtg-Book is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Mtg-Book; if not, write to the 
//
// Free Software Foundation, Inc.
// 59 Temple Place, Suite 330
// Boston, MA 02111-1307
// USA

#if ! defined(_MTG_USTBOND_)
#define _MTG_USTBOND_

#include "MtgClaim.h"
#include "MtgLookup.h"

MTG_BEGIN_NAMESPACE

class tInterestSpline;
class tParser;
class tPortfolio;


//
//   t U S T B o n d
//

class tUSTBond : public tClaim {

    typedef tClaim super;

    double m_gPrincipal;
    double m_gCoupon;

    tDate m_Settlement;

    void init();
    void copyFrom( const tUSTBond& Bond );

    double payoff( tEngine& Engine );

    tRetCode parseParam( tParser& Parser, tParseInfoStub& Info );
    tRetCode parsePostfix( tParser& Parser, tParseInfoStub& Info );
        
public:

    tUSTBond();
    tUSTBond( const tUSTBond& Bond );

    ~tUSTBond();

    tUSTBond& operator=( const tUSTBond& Bond );

    tObject* clone() const;

    tRetCode finalize();
    tRetCode resolve( tLookup<int>& Bond, tLookup<int>& Factor,
        tHeap<tFactor*>& FactorPtr, tPortfolio& Pf );

    bool addPaymentStream( tInterestSpline& Spline ) const;
};

MTG_END_NAMESPACE

#endif

