// Copyright 1999, 2002 Robert Buff
// Contact: http://robertbuff.com/uvm
//
// This file is part of Mtg-Book.
//
// Mtg-Book is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2 of the License,
// or (at your option) any later version.
//
// Mtg-Book is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Mtg-Book; if not, write to the 
//
// Free Software Foundation, Inc.
// 59 Temple Place, Suite 330
// Boston, MA 02111-1307
// USA

#if ! defined(_MTG_VOL_)
#define _MTG_VOL_

#include "MtgObject.h"

MTG_BEGIN_NAMESPACE

    
//
//   t V o l
//
    
class tVol : public tObject {

    typedef tObject super;

protected:

    struct tParseInfo : super::tParseInfoStub {
        double m_gPlusBand;
        double m_gMinusBand;
    };

    int m_nMaturity;
    int m_nConstantUntil;
    int m_nCertainUntil;
    int m_nCertainAfter;

    void copyFrom( const tVol& Vol );

public:

    tVol();
    tVol( const tVol& Vol );

    ~tVol();

        // Object must be finalized:

    int maturity() const {
        return m_nMaturity; 
    }

    int constantUntil() const {
        return m_nConstantUntil;
    }

    int certainUntil() const {
        return m_nCertainUntil;
    }

    int certainAfter() const {
        return m_nCertainAfter;
    }

    bool isUncertain() const {
        return m_nCertainUntil < m_nMaturity;
    }

    virtual void getFwdRange( double& gMin, double& gMax ) const = 0;
    virtual double forward( int nDay ) const = 0;
    virtual double forward( int nFromDay, int nToDay ) const = 0;
    virtual double implied( int nMaturity ) const = 0;
    virtual void forward( int nDay, double& gMin, double& gMax ) const = 0;
    virtual void forward( int nFromDay, int nToDay, double& gMin,
        double& gMax ) const = 0;
    virtual void implied( int nMaturity, double& gMin,
        double& gMax ) const = 0;
    virtual void forward( int nDay, double& gPrior, double& gMin,
        double& gMax ) const = 0;
    virtual void forward( int nFromDay, int nToDay, double& gPrior,
        double& gMin, double& gMax ) const = 0;
    virtual void implied( int nMaturity, double& gPrior,
        double& gMin, double& gMax ) const = 0;

    static tRetCode parse( tParser& Parser, tSystem& System, tObject*& pObj );
};

MTG_END_NAMESPACE

#endif
