// Copyright 1999, 2002 Robert Buff
// Contact: http://robertbuff.com/uvm
//
// This file is part of Mtg-Book.
//
// Mtg-Book is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2 of the License,
// or (at your option) any later version.
//
// Mtg-Book is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Mtg-Book; if not, write to the 
//
// Free Software Foundation, Inc.
// 59 Temple Place, Suite 330
// Boston, MA 02111-1307
// USA

#include "MtgIncl.h"
#include "MtgWithSystem.h"
#include "MtgSystem.h"

MTG_BEGIN_NAMESPACE


//
//   c o p y F r o m
//

void tWithSystem::copyFrom( const tWithSystem& With )

{
    if( &With == this )
        return;

        // Note that the system object itself is not copied.
        // We only inherit the reference.

    setSystem( With.m_pSystem );
}


//
//   t W i t h S y s t e m
//

tWithSystem::tWithSystem()

{
    m_pSystem = 0;
}


//
//   t W i t h S y s t e m
//

tWithSystem::tWithSystem( const tWithSystem& With )

{
    m_pSystem = With.m_pSystem;
    if( m_pSystem != 0 )
        m_pSystem->upRef();
}


//
//   ~ t W i t h S y s t e m
//

tWithSystem::~tWithSystem()

{
    if( m_pSystem != 0 ) {
        m_pSystem->downRef();
        if( m_pSystem->canDelete() )
            delete m_pSystem;
    }
}


//
//   s e t S y s t e m
//

void tWithSystem::setSystem( tSystem* pSystem )

{
    if( m_pSystem != pSystem ) {
        if( m_pSystem != 0 ) {
            m_pSystem->downRef();
            if( m_pSystem->canDelete() )
                delete m_pSystem;
        }
        m_pSystem = pSystem;
        if( m_pSystem != 0 )
            m_pSystem->upRef();
    }
}

MTG_END_NAMESPACE
