// Copyright 1999, 2002 Robert Buff
// Contact: http://robertbuff.com/uvm
//
// This file is part of Mtg-Book.
//
// Mtg-Book is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2 of the License,
// or (at your option) any later version.
//
// Mtg-Book is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Mtg-Book; if not, write to the 
//
// Free Software Foundation, Inc.
// 59 Temple Place, Suite 330
// Boston, MA 02111-1307
// USA

#if ! defined(_MTG_WITH_SYSTEM_)
#define _MTG_WITH_SYSTEM_

MTG_BEGIN_NAMESPACE

class tSystem;


//
//   t W i t h S y s t e m
//

class tWithSystem {

        // An object may know which system object it is 
        // supposed to use. This pointer is maintained
        // through the tObject reference mechanism.

    tSystem* m_pSystem;

protected:

    void copyFrom( const tWithSystem& With );

public:

    tWithSystem();
    tWithSystem( const tWithSystem& With );

    ~tWithSystem();

    void setSystem( tSystem* pSystem );
    void setSystem( tSystem& System ) {
        setSystem( &System );
    }

    tSystem& system() {
        MTG_ASSERT( m_pSystem != 0 );
        return *m_pSystem;
    }

    const tSystem& constSystem() const {
        MTG_ASSERT( m_pSystem != 0 );
        return *m_pSystem;
    }
};

MTG_END_NAMESPACE

#endif
