// Copyright 1999, 2002 Robert Buff
// Contact: http://robertbuff.com/uvm
//
// This file is part of Mtg-Book.
//
// Mtg-Book is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2 of the License,
// or (at your option) any later version.
//
// Mtg-Book is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Mtg-Book; if not, write to the 
//
// Free Software Foundation, Inc.
// 59 Temple Place, Suite 330
// Boston, MA 02111-1307
// USA

#if ! defined(_MTG_WORST_CASE_)
#define _MTG_WORST_CASE_

#include "MtgScenario.h"

MTG_BEGIN_NAMESPACE

class tParser;


//
//   t W o r s t C a s e
//

class tWorstCase : public tScenario {

    typedef tScenario super;

    void init();

protected: 

    tRetCode parseParam( tParser& Parser, tParseInfoStub& Info );

public:

    tWorstCase();
    tWorstCase( const tWorstCase& Worst );

    ~tWorstCase();

    void reset();

    tWorstCase& operator=( const tWorstCase& Worst );

    void copyFrom( const tWorstCase& Worst );

    tObject* clone() const;

    tRetCode finalize();

    bool underControl( double gMultiplier );

    void refineExPolicy( tFDEngine& Engine, int nBaseTag, int nIndex,
        double gDontExValue, double gExValue, double gMultiplier,
        tExPolicy& nExPolicy );

        // The following version is used when xMayExercised is
        // approximated by xDontExercise or xForceExercise,
        // returned in nExPolicy0.

    void refineExPolicy( tFDEngine& Engine, int nBaseTag, int nIndex, 
        double gDontExValue, double gExValue, double gMultiplier,
        tExPolicy& nExPolicy, tExPolicy& nExPolicy0 );

    double selectVol( int nTag, double gGamma, double gPrior,
        double gMin, double gMax );

    bool endureOver( int nTag, double gNewTotal, double gOldTotal );
    bool chooseOver( int nTag, double gNewTotal, double gOldTotal );
};

MTG_END_NAMESPACE

#endif
