// Copyright 1999, 2002 Robert Buff
// Contact: http://robertbuff.com/uvm
//
// This file is part of Mtg-Book.
//
// Mtg-Book is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2 of the License,
// or (at your option) any later version.
//
// Mtg-Book is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Mtg-Book; if not, write to the 
//
// Free Software Foundation, Inc.
// 59 Temple Place, Suite 330
// Boston, MA 02111-1307
// USA

#include <iostream.h>
#include <limits.h>

#include "Mtg.h"
MTG_USING_NAMESPACE

// This example creates a coupon compounder, checks
// for compounding dates and computes compounding periods.
 

//
//   m a i n
//

void main()

{
    char s[512];

        // specify coupon structure
        
    cout << "Enter the maturity date and the number of coupons: ";
    cin.get( s, sizeof( s ) );

    tDate Maturity;
    int nPeriods;

    const char* q = Maturity.set( s );

    if( q == 0 || sscanf( q, "%d", &nPeriods ) != 1 )
        return;

        // specify policy for non-businessdays

    int nPolicy, nMove;

    cout << "Specify policy for non-businessdays, as in\n";
    cout << "1=no change 2=following 3=preceding 4=modified following: ";
    cin >> nPolicy;

    if( nPolicy == 2 || nPolicy == 3 ) {
        cout << "Parameter (-1, 0, or positive): ";
        cin >> nMove;
    }

    tDayShift* pShift;

    switch( nPolicy ) {
        case 1  : pShift = new tIdentityDayShift();         break;
        case 2  : pShift = new tFollowingDayShift( nMove ); break;
        case 3  : pShift = new tPrecedingDayShift( nMove ); break;
        case 4  : pShift = new tModifiedDayShift();         break;
        default : return;
    }

        // define the compounder

    tCouponCompounder Compounder( Maturity, *pShift, nPeriods );
    delete pShift;  // no longer needed

    tDate M = Compounder.maturity();

    if( M != Maturity ) {
        Maturity = M;
        cout << "The adjusted maturity date is "
             << Maturity.month() << "/"
             << Maturity.day() << "/"
             << Maturity.year() << "\n";
    }

    while( true ) {
            // skip line
        cin.ignore( INT_MAX, '\n' );

        cout << "Enter two dates: ";
        cin.get( s, sizeof( s ) );

        tDate A, B; 
        const char* q = s;

            // scan the string for two dates

        if( ( q = A.set( q ) ) == 0 || B.set( q ) == 0 )
            break;

        if( Compounder.isCompoundingDate( A ) )
            cout << "The first date is a compounding date\n";
        if( Compounder.isCompoundingDate( B ) )
            cout << "The second date is a compounding date\n";

        cout << "Number of compounding dates between first "
             << "and second date is "
             << Compounder.numOfCompoundingDates( A, B ) << "\n";

            // recall that the maturity is day shift-adjusted
            
        cout << "Number of compounding dates between first "
             << "date and maturity is "
             << Compounder.numOfCompoundingDates( A, Maturity ) << "\n";

            // find the compounding periods; note that these can be
            // virtual:

        tDate X, Y;

        Compounder.getCompoundingPeriod( A, X, Y );
        cout << "The compounding period of the first date is "
             << X.month() << "/" << X.day() << "/" << X.year() << " to "
             << Y.month() << "/" << Y.day() << "/" << Y.year() << "\n";

        Compounder.getCompoundingPeriod( B, X, Y );
        cout << "The compounding period of the second date is "
             << X.month() << "/" << X.day() << "/" << X.year() << " to "
             << Y.month() << "/" << Y.day() << "/" << Y.year() << "\n";
    }
}
