// Copyright 1999, 2002 Robert Buff
// Contact: http://robertbuff.com/uvm
//
// This file is part of Mtg-Book.
//
// Mtg-Book is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2 of the License,
// or (at your option) any later version.
//
// Mtg-Book is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Mtg-Book; if not, write to the 
//
// Free Software Foundation, Inc.
// 59 Temple Place, Suite 330
// Boston, MA 02111-1307
// USA

#include <iostream.h>
#include <limits.h>

#include "Mtg.h"
MTG_USING_NAMESPACE

// This finds the money market and bond equivalent yield
// for a discount paper. (Note that this functionality is also
// implemented in tBondMath; here we're doing it elementary for
// illustration purposes.)
 

//
//   m a i n
//

void main()

{
    char s[512];

        // initialize various interest conventions

    tInterest Discount(
        tInterest::xLinear,
        tInterest::xDiscount,
        DayCountACT_360,
        tPeriodCompounder( 1 ) );

    tInterest MMYield(
        tInterest::xLinear,
        tInterest::xYield,
        DayCountACT_360,
        tPeriodCompounder( 1 ) );

    tInterest BEYield(
        tInterest::xLinear,
        tInterest::xYield,
        DayCountACT_365,
        tPeriodCompounder( 2 ) );

    while( true ) {
        cout << "Enter settlement and maturity date, "
             << "and ann. discount[%]: ";
        cin.get( s, sizeof( s ) );
        cin.ignore( INT_MAX, '\n' );

        tDate S, M; // settlement and maturity
        double d;   // discount

        const char* q = s;

            // scan the string for two dates and a number

        if( ( q = S.set( q ) ) == 0 ||
            ( q = M.set( q ) ) == 0 ||
            sscanf( q, "%lg", &d ) != 1 ) {
            break;
        }

        d /= 100;            

            // compute the price of the discount paper

        double p = Discount.presentValue( S, M, d );
        cout << "Price is " << 100 * p << "\n";

            // translate to other quotations

        cout << "Money market yield is "
             << 100 * MMYield.invPresentValue( S, M, p ) << "\n";
        cout << "Bond equivalent yield is "
             << 100 * BEYield.invPresentValue( S, M, p ) << "\n";
    }
}
