// Copyright 1999, 2002 Robert Buff
// Contact: http://robertbuff.com/uvm
//
// This file is part of Mtg-Book.
//
// Mtg-Book is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2 of the License,
// or (at your option) any later version.
//
// Mtg-Book is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Mtg-Book; if not, write to the 
//
// Free Software Foundation, Inc.
// 59 Temple Place, Suite 330
// Boston, MA 02111-1307
// USA

#include <iostream.h>
#include <limits.h>

#include "Mtg.h"
MTG_USING_NAMESPACE

// This example demonstrates tStepDrift, a class for
// the efficient use of forward rate curves, with 
// "mathematical" modeling and calendar date based
// retrieval.


//
//   g e t P a r a m e t e r s
//

void getParameters( tStepDrift& Drift )

{
    cout << "*** Parameters" << endl;

        // fet scale

    cout << "1=day 2=year" << endl;

    int c;

    cout << "Enter the time unit for curve: ";
    cin >> c;

    switch( c ) {
        case 1 :
            Drift.set( xDay );
            break;

        case 2 : 
            cout << "Enter the number of periods per year: ";
            cin >> c;
            Drift.set( xYear, c );
            break;

        default: exit( 1 );
    }

        // get day count convention

    cout << "1=ACT/ACT     2=ACT/365   3=ACT/365NL" << endl
         << "4=ACT/365ISDA 5=ACT/360   6=30/360ISDA" << endl
         << "7=30/360PSA   8=30/360SIA 9=30E/360" << endl;

    cout << "Enter the day count convention: ";
    cin >> c;

    switch( c ) {
        case 1 : Drift.set( DayCountACT_ACT );      break;
        case 2 : Drift.set( DayCountACT_365 );      break;
        case 3 : Drift.set( DayCountACT_365_NL );   break;
        case 4 : Drift.set( DayCountACT_365_ISDA ); break;
        case 5 : Drift.set( DayCountACT_360 );      break;
        case 6 : Drift.set( DayCount30_360_ISDA );  break;
        case 7 : Drift.set( DayCount30_360_PSA );   break;
        case 8 : Drift.set( DayCount30_360_SIA );   break;
        case 9 : Drift.set( DayCount30E_360 );      break;
        default: exit( 1 );
    }

        // get base date

    char s[64];

    cout << "Enter base date: ";
    cin.ignore( INT_MAX, '\n' );
    cin.get( s, sizeof( s ) );

    tDate Base;

    if( Base.set( s ) == 0 )
        exit( 1 );  // illegal date

    Drift.set( Base );
}


//
//   g e t D a t a
//

void getData( tStepDrift& Drift )

{
    cout << "*** Data" << endl;

    while( true ) {
        char cType;

        cout << "Enter type (<i>/<f>), time unit, value or <x>: ";
        cin >> cType;

        cType = tolower( cType );

        if( cType == 'i' || cType == 'f' ) {
            int nUnit;
            double gValue;

            cin >> nUnit >> gValue;

            if( cType == 'i' )
                Drift.addImplied( nUnit, gValue );
            else
                Drift.addForward( nUnit, gValue );
        }
        else {
            break;
        }
    }
}


//
//   m a i n
//

void main()

{
    tStepDrift Drift;

    getParameters( Drift );
    getData( Drift );

        // important:
        
    Drift.finalize();

        // compute discount rates

    cout << "*** Compute discount rates" << endl;

    while( true ) {
        char cType;

        cout << "Enter type of interval (<i>nteger, <r>eal, <d>ates): ";
        cin >> cType;

        cType = tolower( cType );

        if( cType == 'i' ) {
            int nStart, nEnd;

            cout << "Enter start and end time units: ";
            cin >> nStart >> nEnd;

            cout << "TU: Forward rate is "
                 << Drift.forwardTU( nStart, nEnd ) << endl;
            cout << "TU: Present value of $1 is $"
                 << Drift.presentValueTU( nStart, nEnd ) << endl;
            cout << "SI: Forward rate is "
                 << Drift.forwardSI( nStart, nEnd ) << endl;
            cout << "SI: Present value of $1 is $"
                 << Drift.presentValueSI( nStart, nEnd ) << endl;
        }
        else
        if( cType == 'r' ) {
            double gStart, gEnd;

            cout << "Enter start and end time units: ";
            cin >> gStart >> gEnd;

            cout << "TU: Forward rate is "
                 << Drift.forwardTU( gStart, gEnd ) << endl;
            if( Drift.scale() != xDay ) {
                cout << "TU: Present value of $1 is $"
                     << Drift.presentValueTU( gStart, gEnd ) << endl;
            }
            cout << "SI: Forward rate is "
                 << Drift.forwardSI( gStart, gEnd ) << endl;
            if( Drift.scale() != xDay ) {
                cout << "SI: Present value of $1 is $"
                     << Drift.presentValueSI( gStart, gEnd ) << endl;
            }
        }
        else
        if( cType == 'd' ) {
            char s[256];
            tDate Start, End;

            cout << "Enter start and end date: ";
            cin.ignore( INT_MAX, '\n' );
            cin.get( s, sizeof( s ) );

            const char* q = s;

            if( ( q = Start.set( s ) ) != 0 && End.set( q ) != 0 ) {
                cout << "Forward rate is "
                     << Drift.forward( Start, End ) << endl;
                cout << "Present value of $1 is $"
                     << Drift.presentValue( Start, End ) << endl;
            }
        }
        else {
            break;
        }
    }
}
