//
//   12/5/98 Robert Buff
//

#include "bfgs.h"

#include <string.h>
#include <float.h>

extern "C" {

#if defined(min)
#undef min
#endif

#if defined(max)
#undef max
#endif

#include "f2c.h"

int lbfgsb_( integer *n, integer *m, doublereal *x,
    doublereal *l, doublereal *u, integer *nbd, doublereal *f,
    doublereal *g, doublereal *factr, doublereal *wa, integer *iwa,
    char *task, integer *iprint, integer *isbmin, char *csave,
    logical *lsave, integer *isave, doublereal *dsave,
    ftnlen task_len, ftnlen csave_len );
}


//
//   t M i n i m i z e r
//

tMtgMinimizer::tMtgMinimizer()

{
    m_gTolerance = 1e-6;
    m_gResult = 0;
    m_bVerbose = false;
}


//
//   s e t T o l e r a n c e
//

void tMtgMinimizer::setTolerance( double gTolerance )

{
    m_gTolerance = gTolerance;
}


//
//   s e t V e r b o s e
//

void tMtgMinimizer::setVerbose( bool bVerbose )

{
    m_bVerbose = bVerbose;
}


//
//   m i n i m i z e
//

void tMtgMinimizer::minimize( int nDim, const double LoBound[], const double HiBound[],
    double Lambda[], double Gradient[] )

{
    double* Lo = new double[nDim];
    double* Hi = new double[nDim];

    memcpy( Lo, LoBound, nDim * sizeof(double) );
    memcpy( Hi, HiBound, nDim * sizeof(double) );

        // make sure lambdas are in the box

    for( int i = 0; i < nDim; ++i ) {
        if( Lambda[i] < Lo[i] )
            Lambda[i] = Lo[i];
        else
        if( Lambda[i] > Hi[i] )
            Lambda[i] = Hi[i];
    }

    char task[61], csave[61];
    logical lsave[4];
    integer isave[44];
    doublereal dsave[29];

    integer n = nDim;
    integer m = 5;
    integer nmax = 1024;
    integer mmax = 17;

    integer iprint = m_bVerbose ? 99 : -1;
    integer isbmin = 1;  // Subspace min. method
                         // BFGS uses factr * machineEpsilon
    double factr = m_gTolerance / DBL_EPSILON; 

    integer* nbd = new integer[n];
    integer* iwa = new integer[3 * nmax];
    double* wa = new double[2 * mmax * nmax + 
                        4 * nmax + 12 * mmax * mmax + 12 * mmax];

    for( i = 0; i < n; ++i )
	    nbd[i] = 2;

    strcpy( task, "START" );
    memset( &task[5], ' ', sizeof(task) - 6 );
    task[sizeof(task) - 1] = 0;
    
    bool bGo = true;

    while( bGo ) {
	    lbfgsb_( &n, &m, &Lambda[0], &Lo[0], &Hi[0], nbd,
            &m_gResult, &Gradient[0], &factr, wa, iwa, task,
            &iprint, &isbmin, csave, lsave, isave, dsave,
            sizeof(task) - 1, sizeof(csave) - 1 );
	
	    if( strncmp( task, "FG", 2 ) == 0 ) {
                // Call the callback function:
	        eval( nDim, Lambda, m_gResult, Gradient );
            // MTG_TRACE( "Optimization: %lg\n", m_gResult );
	    }
	    else 
        if( strncmp( task, "NEW_X", 5 ) != 0 ) {
	        bGo = false;
        }
    }

    delete Lo;
    delete Hi;

    delete nbd;
    delete wa;
    delete iwa;
}


//
//   m i n i m i z e
//

void tMtgMinimizer::minimize( int nDim, double gLoBound, double gHiBound,
    double Lambda[], double Gradient[] )

{
    double* Lo = new double[nDim];
    double* Hi = new double[nDim];

    for( int i = 0; i < nDim; ++i ) {
        Lo[i] = gLoBound;
        Hi[i] = gHiBound;
    }

    minimize( nDim, Lo, Hi, Lambda, Gradient );

    delete Lo;
    delete Hi;
}


//
//   m i n i m i z e
//

void tMtgMinimizer::minimize( int nDim, const double LoBound[], const double HiBound[],
    double Lambda[] )

{
    double* Gradient = new double[nDim];

    minimize( nDim, LoBound, HiBound, Lambda, Gradient );
    delete Gradient;
}


//
//   m i n i m i z e
//

void tMtgMinimizer::minimize( int nDim, double gLoBound, double gHiBound,
    double Lambda[] )

{
    double* Gradient = new double[nDim];

    minimize( nDim, gLoBound, gHiBound, Lambda, Gradient );
    delete Gradient;
}
