// Copyright 1999, 2002 Robert Buff
// Contact: http://robertbuff.com/uvm
//
// This file is part of Mtg-Book.
//
// Mtg-Book is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2 of the License,
// or (at your option) any later version.
//
// Mtg-Book is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Mtg-Book; if not, write to the 
//
// Free Software Foundation, Inc.
// 59 Temple Place, Suite 330
// Boston, MA 02111-1307
// USA

package nom.rb.MtgClt;
import nom.rb.common.*;

import java.awt.*;


///////////////////////////////////////////////////////////////////

//
//   A b o u t D i a l o g
//

public class AboutDialog extends Dialog {


//
//   v a r i a b l e s
//

private Button m_OK;
private MultiLineLabel m_label;


//
//   A b o u t D i a l o g
//

public AboutDialog()

{
	super( Pool.m_frame, "About", true );

	setResizable( false );

	String s = new String( Pool.m_aboutInfo );
	if( ! s.endsWith( "\n" ) )
	  s += "\n";

    s += " \n Java " +
         System.getProperty( "java.version" ) + "\non " +
		 System.getProperty( "os.name" ) + " " +
		 System.getProperty( "os.version" );
    
    m_label = new MultiLineLabel( s, 20, 20 );
	m_OK = new Button( "   Ok   " );

	setLayout( new BorderLayout() );

	Panel p = new Panel();
	p.setLayout( new FlowLayout( FlowLayout.CENTER, 15, 15 ) );

	add( "Center", m_label );
	p.add( m_OK );
	add( "South", p );

	pack();
}


//
//   h a n d l e E v e n t
//

public boolean handleEvent( Event evt )

{
    switch( evt.id ) {
	    case Event.WINDOW_DESTROY:
            hide();
		    dispose();
            return true;

        default:
            return super.handleEvent( evt );
    }			 
}


//
//   a c t i o n
//

public boolean action( Event evt, Object obj )

{
    if( evt.target == m_OK ) {
        hide();
	    dispose();
	    return true;
	}

	return false;
}


//
//   g o t F o c u s
//

public boolean gotFocus( Event evt, Object obj )

{
    m_OK.requestFocus();
    return true;
}

} // end of class
