// Copyright 1999, 2002 Robert Buff
// Contact: http://robertbuff.com/uvm
//
// This file is part of Mtg-Book.
//
// Mtg-Book is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2 of the License,
// or (at your option) any later version.
//
// Mtg-Book is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Mtg-Book; if not, write to the 
//
// Free Software Foundation, Inc.
// 59 Temple Place, Suite 330
// Boston, MA 02111-1307
// USA

package nom.rb.MtgClt;
import nom.rb.common.*;

import java.awt.*;


///////////////////////////////////////////////////////////////////

//
//   C l a i m
//

public class Claim extends Object {


//
//   v a r i a b l e s
//

    // the following variables are for the GUI        

private int m_id;

private ExtChoice m_chType;

private ExtTextField m_tfMaturity;
private ExtTextField m_tfStrike;
private ExtTextField m_tfUpAndOut;
private ExtTextField m_tfDownAndOut;

private Choice m_chPosition;
private ExtTextField m_tfAmount;

private ExtCheckbox m_cbActive;

private String m_customEntries[];

private Component m_wrongComp;

    // the following variables hold the values after preparation

private String m_paramSpec;
private int m_paramMaturity;
private double m_paramPosition;

    // some constants

private static final int CUSTOM = 8;


//
//   C l a i m
//

public Claim( int id )

{
    m_id = id;

    m_chType = new ExtChoice( m_id );
    m_chType.addItem( "European Call" );      // 0
    m_chType.addItem( "European Put" );       // 1
    m_chType.addItem( "American Call" );      // 2
    m_chType.addItem( "American Put" );       // 3
    m_chType.addItem( "Eu Digital Call" );    // 4
    m_chType.addItem( "Eu Digital Put" );     // 5
    m_chType.addItem( "Am Digital Call" );    // 6
    m_chType.addItem( "Am Digital Put" );     // 7
    m_chType.addItem( "Custom" );             // 8

    m_tfMaturity = new ExtTextField( m_id, 6 );
    m_tfStrike = new ExtTextField( m_id, 6 );
    m_tfUpAndOut = new ExtTextField( m_id, 6 );
    m_tfDownAndOut = new ExtTextField( m_id, 6 );

    m_chPosition = new Choice();
    m_chPosition.addItem( "Long" );
    m_chPosition.addItem( "Short" );

    m_tfAmount = new ExtTextField( m_id, 6 );

    m_cbActive = new ExtCheckbox( m_id );

    if( Pool.m_bgColor != null )
        m_cbActive.setBackground( Pool.m_bgColor );
}


//
//   c l e a r
//

public void clear()

{
    m_chType.select( 0 );
    m_tfMaturity.setText( "" );
    m_tfStrike.setText( "" );
    m_tfUpAndOut.setText( "" );
    m_tfDownAndOut.setText( "" );
    m_chPosition.select( 0 );
    m_tfAmount.setText( "1" );
    m_cbActive.setState( true );

    m_customEntries = null;

    adjust();
}


//
//   a d j u s t
//

public void adjust()

{
    if( m_cbActive.getState() ) {
        m_chType.enable();
        m_tfMaturity.enable();
        m_chPosition.enable();
        m_tfAmount.enable();

        if( m_chType.getSelectedIndex() == CUSTOM ) {
            m_tfStrike.disable();
            m_tfUpAndOut.disable();
            m_tfDownAndOut.disable();
        }
        else {
            m_tfStrike.enable();
            m_tfUpAndOut.enable();
            m_tfDownAndOut.enable();
        }
    }
    else {
        m_chType.disable();
        m_tfMaturity.disable();
        m_tfStrike.disable();
        m_tfUpAndOut.disable();
        m_tfDownAndOut.disable();
        m_chPosition.disable();
        m_tfAmount.disable();
    }
}


//
//   a d j u s t
//

public boolean adjust( Custom custom )

{
    adjust();
    return adjustCustom( custom );
}


//
//   a d j u s t C u s t o m
//

public boolean adjustCustom( Custom custom )

{
    if( m_chType.getSelectedIndex() == CUSTOM ) {
        if( custom == null )
            return false;
        custom.restore( m_customEntries,
            m_tfUpAndOut.getText(),
            m_tfDownAndOut.getText(),
            m_tfMaturity.getText() );
        custom.enable( m_cbActive.getState() );
    }
    else {
        if( custom != null ) {
            custom.clear();
            custom.disable();
        }
    }
    return true;
}


//
//   r e t r i e v e C u s t o m
//

public void retrieveCustom( Custom custom )

{
    if( m_chType.getSelectedIndex() == CUSTOM && custom != null )
        m_customEntries = custom.save();
}


//
//   a d d
//

public void add( Panel table, int row )

{
    GridBagLayout layout = (GridBagLayout) table.getLayout();
    GridBagConstraints c = new GridBagConstraints();

    c.anchor = GridBagConstraints.NORTHWEST;
    c.ipadx = 10;
    c.gridy = row;

    table.add( m_chType );
    layout.setConstraints( m_chType, c );
    table.add( m_tfMaturity );
    layout.setConstraints( m_tfMaturity, c );
    table.add( m_tfStrike );
    layout.setConstraints( m_tfStrike, c );
    table.add( m_tfUpAndOut );
    layout.setConstraints( m_tfUpAndOut, c );
    table.add( m_tfDownAndOut );
    layout.setConstraints( m_tfDownAndOut, c );
    table.add( m_chPosition );
    layout.setConstraints( m_chPosition, c );
    table.add( m_tfAmount );
    layout.setConstraints( m_tfAmount, c );
    table.add( m_cbActive );
    layout.setConstraints( m_cbActive, c );
}


//
//   i s A c t i v e
//

public boolean isActive()

{
    if( ! m_cbActive.getState() )
        return false;

    if( ! m_tfMaturity.hasValue( 0 ) )
        return false;

    if( m_chType.getSelectedIndex() != CUSTOM ) {
        if( ! m_tfStrike.hasValue() )
            return false;
    }

    if( ! m_tfAmount.hasValue( 0 ) )
        return false;

    return true;
}


//
//   p r e p a r e
//

public void prepare( Custom custom )
    throws DataException

{
    if( m_chType.getSelectedIndex() == CUSTOM && custom != null ) {
        try {
            custom.prepare();
        }
        catch( DataException e ) {
            m_wrongComp = null;
            throw e;
        }
        retrieveCustom( custom );
    }

    prepare();
}


//
//   p r e p a r e
//

public void prepare()
    throws DataException

{
    m_wrongComp = m_tfMaturity;
    m_paramMaturity = m_tfMaturity.getPosInt();

    if( m_chType.getSelectedIndex() != CUSTOM ) {
        switch( m_chType.getSelectedIndex() ) {
            case 0 : case 4 :
                m_paramSpec = "type european_call";
                break;
            case 1 : case 5 :
                m_paramSpec = "type european_put";
                break;
            case 2 : case 6 :
                m_paramSpec = "type american_call";
                break;
            case 3 : case 7 :
                m_paramSpec = "type american_put";
                break;
            default :
                throw new InternalError();
        }

        switch( m_chType.getSelectedIndex() ) {
            case 4 : case 5 : case 6 : case 7 :
                m_paramSpec += ", payoff digital";
                break;
        }

        m_wrongComp = m_tfStrike;
        m_paramSpec += ", strike " + m_tfStrike.getNonNegDouble();

        if( m_tfUpAndOut.hasValue() ) {
            m_wrongComp = m_tfUpAndOut;
            m_paramSpec += ", up_and_out " + m_tfUpAndOut.getPosDouble();
        }

        if( m_tfDownAndOut.hasValue( 0 ) ) {
            m_wrongComp = m_tfDownAndOut;
            m_paramSpec += ", down_and_out " + m_tfDownAndOut.getPosDouble();
        }
    }
    else {
        m_paramSpec = Custom.prepare( m_customEntries );
    }

    m_wrongComp = m_tfAmount;
    m_paramPosition = m_tfAmount.getDouble();
    if( m_chPosition.getSelectedIndex() != 0 )
        m_paramPosition = -m_paramPosition;
}


//
//   w r o n g C o m p
//

public Component wrongComp()

{
        // to be retrieved after prepare() throws a DataException
    return m_wrongComp;
}


//
//   t f M a t u r i t y
//

public ExtTextField tfMaturity()

{
    return m_tfMaturity;
}


//
//   p a r a m M a t u r i t y
//

public int paramMaturity()

{
    return m_paramMaturity;
}


//
//   p r o t C l a i m
//

public String protClaim()

{
    String s =
        "claim C" + m_id + " { " + m_paramSpec +
        ", maturity " + m_paramMaturity;

    return s + " }";
}


//
//   p r o t P o s i t i o n
//

public String protPosition()

{
    String s = "C" + m_id;

    if( m_paramPosition >= 0 )
        s += " long " + m_paramPosition;
    else
        s += " short " + -m_paramPosition;

    return s;
}


//
//   s e t E x a m p l e
//

public void setExample( int nom )

{
    clear();

    switch( nom ) {
        case 0 :
            m_tfMaturity.setText( "60" );
            m_tfStrike.setText( "105" );
            break;

        case 1 :
            m_chType.select( 1 );
            m_tfMaturity.setText( "60" );
            m_tfStrike.setText( "100" );
            m_chPosition.select( 1 );
            m_tfAmount.setText( "2" );
            break;

        case 2 :
            m_chType.select( 1 );
            m_tfMaturity.setText( "60" );
            m_tfStrike.setText( "100" );
            m_chPosition.select( 1 );
            m_tfAmount.setText( "2" );
            m_cbActive.setState( false );
            adjust();
            break;

        case 3 :
            m_tfMaturity.setText( "60" );
            m_tfStrike.setText( "100" );
            m_tfUpAndOut.setText( "120" );
            break;

        case 4 :
            m_chType.select( 2 );
            m_tfMaturity.setText( "90" );
            m_tfStrike.setText( "90" );
            m_tfUpAndOut.setText( "125" );
            m_tfDownAndOut.setText( "80" );
            break;

        case 5 :
            m_chType.select( CUSTOM );
            m_tfMaturity.setText( "90" );
            break;

        case 6 :
            m_chType.select( CUSTOM );
            m_tfMaturity.setText( "100" );
            break;

        case 7 :
            m_chType.select( CUSTOM );
            m_tfMaturity.setText( "100" );
            break;
    }

    m_customEntries = Custom.saveExample( nom );
}


//
//   c o p y F r o m
//

public void copyFrom( Claim claim )

{
    m_chType.select( claim.m_chType.getSelectedIndex() );
    m_tfMaturity.setText( claim.m_tfMaturity.getText() );
    m_tfStrike.setText( claim.m_tfStrike.getText() );
    m_tfUpAndOut.setText( claim.m_tfUpAndOut.getText() );
    m_tfDownAndOut.setText( claim.m_tfDownAndOut.getText() );
    m_chPosition.select( claim.m_chPosition.getSelectedIndex() );
    m_tfAmount.setText( claim.m_tfAmount.getText() );
    m_cbActive.setState( claim.m_cbActive.getState() );

    if( claim.m_customEntries != null ) {
        m_customEntries = new String[claim.m_customEntries.length];
        for( int i = 0; i < m_customEntries.length; ++i )
            m_customEntries[i] = claim.m_customEntries[i];
    }

    adjust();
}

} // end of class
