// Copyright 1999, 2002 Robert Buff
// Contact: http://robertbuff.com/uvm
//
// This file is part of Mtg-Book.
//
// Mtg-Book is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2 of the License,
// or (at your option) any later version.
//
// Mtg-Book is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Mtg-Book; if not, write to the 
//
// Free Software Foundation, Inc.
// 59 Temple Place, Suite 330
// Boston, MA 02111-1307
// USA

package nom.rb.MtgClt;
import nom.rb.common.*;

import java.awt.*;


///////////////////////////////////////////////////////////////////

//
//   C u s t o m
//

public class Custom extends ParamSpace {


//
//   v a r i a b l e s
//

    // the following variables are for the GUI        

private ExtTextField m_tfMaturity;

private ExtTextField m_tfPayoff;
private ExtTextField m_tfKnockoutPayoff;
private ExtTextField m_tfExercisePayoff;
private ExtTextField m_tfUpAndOut;
private ExtTextField m_tfDownAndOut;
private ExtTextField m_tfMonitor;

    // these are the parameters for the calculation

private String m_paramSpec;


//
//   C u s t o m
//

public Custom()

{
    super( Id.CUSTOM );

    GridBagLayout layout = new GridBagLayout();
    setLayout( layout );

    GridBagConstraints c = new GridBagConstraints();

    c.anchor = GridBagConstraints.NORTHWEST;
    c.gridx = 0;
    add( createTable1(), c );

    if( Pool.m_bgColor != null )
        setBackground( Pool.m_bgColor );

    clear();                    
}


//
//   c l e a r
//

public void clear()

{
    clearWrong();

    m_tfMaturity.setText( "" );
    m_tfPayoff.setText( "" );
    m_tfKnockoutPayoff.setText( "" );
    m_tfExercisePayoff.setText( "" );
    m_tfUpAndOut.setText( "" );
    m_tfDownAndOut.setText( "" );
    m_tfMonitor.setText( "" );
}


//
//   e n a b l e
//

public void enable( boolean on )

{
    if( on )
        enable();
    else
        disable();
}


//
//   e n a b l e
//

public void enable()

{
    m_tfMaturity.enable();
    m_tfPayoff.enable();
    m_tfKnockoutPayoff.enable();
    m_tfExercisePayoff.enable();
    m_tfUpAndOut.enable();
    m_tfDownAndOut.enable();
    m_tfMonitor.enable();
}


//
//   d i s a b l e
//

public void disable()

{
    m_tfMaturity.disable();
    m_tfPayoff.disable();
    m_tfKnockoutPayoff.disable();
    m_tfExercisePayoff.disable();
    m_tfUpAndOut.disable();
    m_tfDownAndOut.disable();
    m_tfMonitor.disable();
}


//
//   r e s t o r e
//

public void restore( String entries[], String upAndOut, String downAndOut,
    String maturity )

{
    if( maturity != null )
        m_tfMaturity.setText( maturity.trim() );
    restore( entries, upAndOut, downAndOut );
}


//
//   r e s t o r e
//

public void restore( String entries[], String upAndOut, String downAndOut )

{
    if( entries == null )
        entries = new String[6];

    if( upAndOut.trim().length() > 0 ) {
        if( entries[3] == null || entries[3].trim().length() == 0 )
            entries[3] = upAndOut.trim();
    }
    if( downAndOut.trim().length() > 0 ) {
        if( entries[4] == null || entries[4].trim().length() == 0 )
            entries[4] = downAndOut.trim();
    }

    restore( entries );
}


//
//   r e s t o r e
//

public void restore( String entries[] )

{
    if( entries == null )
        entries = new String[6];

    for( int i = 0; i < 6; ++i ) {
        if( entries[i] == null ) 
            entries[i] = "";
    }

    m_tfPayoff.setText( entries[0] );
    m_tfKnockoutPayoff.setText( entries[1] );
    m_tfExercisePayoff.setText( entries[2] );
    m_tfUpAndOut.setText( entries[3] );
    m_tfDownAndOut.setText( entries[4] );
    m_tfMonitor.setText( entries[5] );
}


//
//   s a v e
//

public String[] save()

{
    String entries[] = new String[6];

    entries[0] = m_tfPayoff.getText();
    entries[1] = m_tfKnockoutPayoff.getText();
    entries[2] = m_tfExercisePayoff.getText();
    entries[3] = m_tfUpAndOut.getText();
    entries[4] = m_tfDownAndOut.getText();
    entries[5] = m_tfMonitor.getText();

    return entries;
}


//
//   e x a m p l e
//

static public String[] saveExample( int nom )

{
    String entries[] = new String[6];

    switch( nom ) {
        case 5 :
            entries[0] = "max(100-s,0)";
            entries[4] = "90";
            break;

        case 6 :
            entries[0] = "max(100-s,0)";
            entries[4] = "if time <= 50 then 90 endif";
            break;

        case 7 :
            entries[0] = "max(100-s,0)";
            entries[5] = "if time == 50 then may_exercise endif";
            break;
    }

    return entries;
}


//
//   p r e p a r e
//

static public String prepare( String entries[] )
    throws DataException

{
    if( entries == null )
        entries = new String[6];

    for( int i = 0; i < 6; ++i ) {
        if( entries[i] == null ) 
            entries[i] = "";
    }

    String paramSpec = "type custom";

    if( entries[0].trim().length() > 0 )
        paramSpec += ",\npayoff { " + entries[0].trim() + " }";
    if( entries[1].trim().length() > 0 )
        paramSpec += ",\nknockout_payoff { " + entries[1].trim() + " }";
    if( entries[2].trim().length() > 0 )
        paramSpec += ",\nexercise_payoff { " + entries[2].trim() + " }";
    if( entries[3].trim().length() > 0 )
        paramSpec += ",\nup_and_out { " + entries[3].trim() + " }";
    if( entries[4].trim().length() > 0 )
        paramSpec += ",\ndown_and_out { " +  entries[4].trim() + " }";
    if( entries[5].trim().length() > 0 )
        paramSpec += ",\nmonitor { " + entries[5].trim() + " }";

    return paramSpec;
}


//
//   p r e p a r e
//

public void prepare()
    throws DataException

{
    clearWrong();
    m_paramSpec = prepare( save() );
}


//
//   p r o t C u s t o m
//

public String protCustom()

{
    return m_paramSpec;
}


//
//   c r e a t e T a b l e 1
//

private Panel createTable1()

{
    Panel table = new Panel();

    GridBagLayout layout = new GridBagLayout();
    table.setLayout( layout );

    GridBagConstraints c = new GridBagConstraints();
    c.anchor = GridBagConstraints.NORTHWEST;
    c.ipadx = 10;

    m_tfMaturity = new ExtTextField( Id.PAYOFF, 6 );
    m_tfMaturity.setEditable( false );

    m_tfPayoff = new ExtTextField( Id.PAYOFF, 40 );
    m_tfKnockoutPayoff = new ExtTextField( Id.KNOCKOUTPAYOFF, 40 );
    m_tfExercisePayoff = new ExtTextField( Id.EXERCISEPAYOFF, 40 );
    m_tfUpAndOut = new ExtTextField( Id.UPANDOUT, 40 );
    m_tfDownAndOut = new ExtTextField( Id.DOWNANDOUT, 40 );
    m_tfMonitor = new ExtTextField( Id.MONITOR, 40 );

    c.gridy = 0;
    add( table, new Label( "Expires" ), c );
    add( table, m_tfMaturity, c );
    c.insets = new Insets( 0, 10, 0, 0 );
    add( table, new Label( "Default" ), c );
    c.gridy = 1;
    c.insets = new Insets( 15, 0, 0, 0 );
    add( table, new Label( "Payoff" ), c );
    add( table, m_tfPayoff, c );
    c.insets = new Insets( 15, 10, 0, 0 );
    add( table, new Label( "0" ), c );
    c.gridy = 2;
    c.insets = new Insets( 15, 0, 0, 0 );
    add( table, new Label( "Up&Out barrier" ), c );
    add( table, m_tfUpAndOut, c );
    c.insets = new Insets( 15, 10, 0, 0 );
    add( table, new Label( "no barrier" ), c );
    c.gridy = 3;
    c.insets = new Insets( 0, 0, 0, 0 );
    add( table, new Label( "Down&Out barrier" ), c );
    add( table, m_tfDownAndOut, c );
    c.insets = new Insets( 0, 10, 0, 0 );
    add( table, new Label( "no barrier" ), c );
    c.gridy = 4;
    c.insets = new Insets( 0, 0, 0, 0 );
    add( table, new Label( "Payoff at knockout" ), c );
    add( table, m_tfKnockoutPayoff, c );
    c.insets = new Insets( 0, 10, 0, 0 );
    add( table, new Label( "0" ), c );
    c.gridy = 5;
    c.insets = new Insets( 15, 0, 0, 0 );
    add( table, new Label( "Early exercise monitor" ), c );
    add( table, m_tfMonitor, c );
    c.insets = new Insets( 15, 10, 0, 0 );
    add( table, new Label( "no early ex." ), c );
    c.gridy = 6;
    c.insets = new Insets( 0, 0, 0, 0 );
    add( table, new Label( "Payoff at early exercise" ), c );
    add( table, m_tfExercisePayoff, c );
    c.insets = new Insets( 0, 10, 0, 0 );
    add( table, new Label( "as payoff" ), c );

    if( Pool.m_bgColor != null )
        table.setBackground( Pool.m_bgColor );

    return table;
}

} // end of class
