// Copyright 1999, 2002 Robert Buff
// Contact: http://robertbuff.com/uvm
//
// This file is part of Mtg-Book.
//
// Mtg-Book is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2 of the License,
// or (at your option) any later version.
//
// Mtg-Book is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Mtg-Book; if not, write to the 
//
// Free Software Foundation, Inc.
// 59 Temple Place, Suite 330
// Boston, MA 02111-1307
// USA

package nom.rb.MtgClt;
import nom.rb.common.*;


///////////////////////////////////////////////////////////////////

//
//   F o r w a r d D r i f t
//

public class ForwardDrift extends Object {


//
//   v a r i a b l e s
//

private int m_maturity;
private double m_drift;


//
//   F o r w a r d D r i f t
//

public ForwardDrift( ImpliedDrift imp )
    throws DataException

{
    m_maturity = imp.maturity();
    m_drift = imp.drift();
}


//
//   F o r w a r d D r i f t
//

public ForwardDrift( ImpliedDrift imp1, ImpliedDrift imp2 )

{
    if( imp1.maturity() >= imp2.maturity() )
        throw new IllegalArgumentException();

    m_maturity = imp2.maturity();
    m_drift = calcForward( imp1.maturity(), imp1.drift(), imp2.drift() );
}


//
//   t o S t r i n g
//

public String toString()

{
    return "forward " + m_maturity + " " + m_drift + "%";
}


//
//   c a l c F o r w a r d
//

private double calcForward( int mat1, double imp1, double imp2 )

{
    return ( m_maturity * imp2 - mat1 * imp1 ) / ( m_maturity - mat1 );
}

} // end of class
