// Copyright 1999, 2002 Robert Buff
// Contact: http://robertbuff.com/uvm
//
// This file is part of Mtg-Book.
//
// Mtg-Book is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2 of the License,
// or (at your option) any later version.
//
// Mtg-Book is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Mtg-Book; if not, write to the 
//
// Free Software Foundation, Inc.
// 59 Temple Place, Suite 330
// Boston, MA 02111-1307
// USA

package nom.rb.MtgClt;

import java.awt.TextField;


///////////////////////////////////////////////////////////////////

//
//   I m p l i e d V o l
//

public class ImpliedVol extends Object {


//
//   v a r i a b l e s
//

private int m_maturity;

private double m_prior;
private double m_min;
private double m_max;

private TextField m_text;


//
//   I m p l i e d V o l
//

public ImpliedVol( int maturity, double[] values )

{
    this( maturity, values, null );
}


//
//   I m p l i e d V o l
//

public ImpliedVol( int maturity, double[] values, TextField text )

{
    m_maturity = maturity;
    m_min = values[0];
    m_max = values[2];

    if( values[1] <= 0 ) 
        m_prior = Math.sqrt( m_min * m_max );
    else
        m_prior = values[1];

    m_text = text;
}


//
//   m a t u r i t y
//

public int maturity()

{
    return m_maturity;
}


//
//   p r i o r
//

public double prior()

{
    return m_prior;
}


//
//   m i n
//

public double min()

{
    return m_min;
}


//
//   m a x
//

public double max()

{
    return m_max;
}


//
//   t e x t
//

public TextField text()

{
    return m_text;
}

} // end of class