// Copyright 1999, 2002 Robert Buff
// Contact: http://robertbuff.com/uvm
//
// This file is part of Mtg-Book.
//
// Mtg-Book is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2 of the License,
// or (at your option) any later version.
//
// Mtg-Book is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Mtg-Book; if not, write to the 
//
// Free Software Foundation, Inc.
// 59 Temple Place, Suite 330
// Boston, MA 02111-1307
// USA

package nom.rb.MtgClt;
import nom.rb.common.*;

import java.awt.*;


///////////////////////////////////////////////////////////////////

//
//   M a i n M e n u
//

public class MainMenu extends MenuBar {


//
//   v a r i a b l e s
//

private Menu m_fileMenu;
private Menu m_editMenu;
private Menu m_actionMenu;
private Menu m_optionMenu;
private Menu m_exampleMenu;
private Menu m_windowMenu;
private Menu m_helpMenu;

private MenuItem m_new;
private MenuItem m_open;
private MenuItem m_save;
private MenuItem m_saveAs;
private MenuItem m_exit;

private MenuItem m_cut;
private MenuItem m_copy;
private MenuItem m_paste;
private MenuItem m_selectAll;

private MenuItem m_start;
private MenuItem m_stop;

private MenuItem m_reset;

private MenuItem m_firewall;

private MenuItem m_portfolio;
private MenuItem m_scenario;
private MenuItem m_advanced;
private MenuItem m_oneClick;

private MenuItem m_tutorial;
private MenuItem m_about;

private final static String SEPARATOR = "-";


//
//   M a i n M e n u
//

public MainMenu()

{
    create();
}


//
//   c o m m a n d
//

public int command( Event evt )

{
    if( evt.target instanceof ExtMenuItem )
        return ( (ExtMenuItem) evt.target ).m_id;
    if( Pool.m_toolbar != null )
        return Pool.m_toolbar.command( evt );
    return Id.UNKNOWN;
}


//
//   b e f o r e R u n
//

public void beforeRun()

{
    m_fileMenu.disable();
    m_editMenu.disable();
    m_optionMenu.disable();
    m_exampleMenu.disable();
    m_helpMenu.disable();
    m_start.disable();
    m_stop.enable();

    if( Pool.m_toolbar != null )
        Pool.m_toolbar.beforeRun();
}


//
//   a f t e r R u n
//

public void afterRun()

{
    m_fileMenu.enable();
    m_editMenu.enable();
    m_optionMenu.enable();
    m_exampleMenu.enable();
    m_helpMenu.enable();
    m_start.enable();
    m_stop.disable();

    if( Pool.m_toolbar != null )
        Pool.m_toolbar.afterRun();
}


//
//   w i z a r d M o d e
//

public void wizardMode()

{
    m_oneClick.setLabel( "One-Click" );
}


//
//   o n e C l i c k M o d e
//

public void oneClickMode()

{
    m_oneClick.setLabel( "Wizard" );
}


//
//   a d j u s t E x a m p l e M e n u
//

public void adjustExampleMenu( String[] m_examples )

{
    for( int k = m_exampleMenu.countItems() - 1; k >= 2; --k )
        m_exampleMenu.remove( k );

    if( m_examples == null || m_examples.length == 0 )
        return;

    for( int k = 0; k < m_examples.length; ++k ) {
        m_exampleMenu.add( 
            new ExtMenuItem( Id.EXAMPLE1 + k, m_examples[k] ) );
    }
}


//
//    c r e a t e
//

private void create()

{
    m_fileMenu = new Menu( "File" );
    m_editMenu = new Menu( "Edit" );
    m_actionMenu = new Menu( "Action" );
    m_optionMenu = new Menu( "Options" );
    m_exampleMenu = new Menu( "Examples" );
    m_windowMenu = new Menu( "Window" );
    m_helpMenu = new Menu( "Help" );

    m_new = new ExtMenuItem( Id.NEW, "New" );
    m_fileMenu.add( m_new );

    m_save = new ExtMenuItem( Id.SAVE, "Save" );
    m_fileMenu.add( m_save );

    m_saveAs = new ExtMenuItem( Id.SAVE_AS, "Save As..." );
    m_fileMenu.add( m_saveAs );
    m_fileMenu.add( SEPARATOR );

    m_exit = new ExtMenuItem( Id.EXIT, "Exit" );
    m_fileMenu.add( m_exit );

    m_copy = new ExtMenuItem( Id.COPY_TO, "Copy to..." );
    m_editMenu.add( m_copy );

    m_selectAll = new ExtMenuItem( Id.SELECT_ALL, "Select all" );
    m_editMenu.add( m_selectAll );

    m_start = new ExtMenuItem( Id.START, "Start" );
    m_actionMenu.add( m_start );

    m_stop = new ExtMenuItem( Id.STOP, "Stop" );
    m_stop.disable();
    m_actionMenu.add( m_stop );

    m_firewall = new ExtMenuItem( Id.FIREWALL, "Firewall..." );
    m_optionMenu.add( m_firewall );

    m_reset = new ExtMenuItem( Id.RESET, "Default settings" );
    m_exampleMenu.add( m_reset );
    m_exampleMenu.add( SEPARATOR );

    m_portfolio = new ExtMenuItem( Id.PORTFOLIO, "Portfolio" );
    m_windowMenu.add( m_portfolio );

    m_scenario = new ExtMenuItem( Id.SCENARIO, "Scenario" );
    m_windowMenu.add( m_scenario );

    m_advanced = new ExtMenuItem( Id.ADVANCED, "Advanced" );
    m_windowMenu.add( m_advanced );

    m_windowMenu.add( new MenuItem( "-" ) );
    m_oneClick = new ExtMenuItem( Id.ONECLICK, "One-Click" );
    m_windowMenu.add( m_oneClick );

    m_tutorial = new ExtMenuItem( Id.TUTORIAL, "Tutorial..." );
    m_helpMenu.add( m_tutorial );

    if( Pool.m_standAlone )
        m_tutorial.disable();

    m_about = new ExtMenuItem( Id.ABOUT, "About..." );
    m_helpMenu.add( m_about );

    add( m_fileMenu );
    add( m_editMenu );
    add( m_actionMenu );
    //add( m_optionMenu );
    add( m_exampleMenu );
    add( m_windowMenu );
    add( m_helpMenu );
}

} // end of class


///////////////////////////////////////////////////////////////////

//
//   E x t M e n u I t e m
//

class ExtMenuItem extends MenuItem {


//
//   v a r i a b l e s
//

public int m_id;


//
//   E x t M e n u I t e m
//

public ExtMenuItem( int id, String label ) {
    super( label );
    m_id = id;
}

} // end of class
