// Copyright 1999, 2002 Robert Buff
// Contact: http://robertbuff.com/uvm
//
// This file is part of Mtg-Book.
//
// Mtg-Book is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2 of the License,
// or (at your option) any later version.
//
// Mtg-Book is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Mtg-Book; if not, write to the 
//
// Free Software Foundation, Inc.
// 59 Temple Place, Suite 330
// Boston, MA 02111-1307
// USA

package nom.rb.MtgClt;
import nom.rb.common.*;

import java.awt.*;


///////////////////////////////////////////////////////////////////

//
//   P a r a m S p a c e
//

public class ParamSpace extends Panel {


//
//   v a r i a b l e s
//

private int m_id;

private Component m_wrongComp;
private Color m_wrongOldColor;
private String m_wrongMsg;

protected String[] m_examples;

    
//
//   P a r a m S p a c e
//
    
public ParamSpace( int id )

{
    m_id = id;
}


//
//   i d
//

public int id()

{
    return m_id;
}


//
//   i d T o S t r i n g
//

public String idToString()

{
    return Integer.toString( m_id );
}


//
//   a d j u s t E x a m p l e M e n u
//

public void adjustExampleMenu()

{
    Pool.m_menu.adjustExampleMenu( m_examples );
}


//
//   c l e a r
//

public void clear()

{
}


//
//   d e t a c h
//

public void detach()

{
}


//
//   e x a m p l e
//

public void example( int num )

{
}


//
//   s h o w W r o n g
//

public void showWrong()

{
    if( m_wrongComp != null ) {
        if( m_wrongMsg != null )
            Pool.m_status.setMsg( m_wrongMsg );
        m_wrongComp.requestFocus();
    }
    else
        if( m_wrongMsg != null ) {
            Pool.ok( "Error", m_wrongMsg );
        }
}


//
//   g e t I n t
//

protected int getInt( TextField text )
    throws DataException

{
    int i = 0;

    try { 
        i = Integer.valueOf( text.getText().trim() ).intValue();
    }
    catch( NumberFormatException e ) {
        setWrong( text );
        panic( "Not a valid number" );
    }

    return i;
}


//
//   g e t P o s I n t
//

protected int getPosInt( TextField text )
    throws DataException

{
    int i = getInt( text );

    if( i <= 0 ) {
        setWrong( text );
        panic( "Number must be strictly positive" );
    }

    return i;
}


//
//   g e t D o u b l e
//

protected double getDouble( TextField text )
    throws DataException

{
    double d = 0;

    try { 
        d = Double.valueOf( text.getText().trim() ).doubleValue();
    }
    catch( NumberFormatException e ) {
        setWrong( text );
        panic( "Not a valid number" );
    }

    return d;
}


//
//   g e t P o s D o u b l e
//

protected double getPosDouble( TextField text )
    throws DataException

{
    double d = getDouble( text );

    if( d <= 0 ) {
        setWrong( text );
        panic( "Number must be strictly positive" );
    }

    return d;
}


//
//   g e t P o s T r i p l e
//

protected double[] getPosTriple( TextField text )
    throws DataException

{
    double d[] = new double[3];
    String s = text.getText().trim();

    int k = s.indexOf( ";" );

    if( k < 0 )
        k = s.indexOf( "-" );

    String q = ( k < 0 ) ? s : s.substring( 0, k );

    try { 
        d[0] = Double.valueOf( q.trim() ).doubleValue();

        if( k >= 0 ) {
            int l = s.indexOf( ";", ++k );

            if( l < 0 )
                l = s.indexOf( "-", k );

            q = ( l < 0 ) ? s.substring( k ) : s.substring( k, l );
            d[1] = Double.valueOf( q.trim() ).doubleValue();

            if( d[1] < d[0] ) {
                double t = d[1];
                d[1] = d[0];
                d[0] = t;
            }

            if( l >= 0 ) {
                q = s.substring( l + 1 );
                d[2] = Double.valueOf( q.trim() ).doubleValue();

                if( d[2] < d[1] ) {
                    double t = d[2];
                    d[2] = d[1];
                    d[1] = t;
                    if( d[1] < d[0] ) {
                        t = d[1];
                        d[1] = d[0];
                        d[0] = t;
                    }
                }
            }
            else {
                d[2] = d[1];
                d[1] = -1;      // needs to be resolved later
            }
        }
        else {
            d[2] = d[1] = d[0];
        }
    }
    catch( NumberFormatException e ) {
        setWrong( text );
        panic( "Not a valid number or range of numbers" );
    }
     
    if( d[0] <= 0 ) {
        setWrong( text );
        panic( "Number must be strictly positive" );
    }

    return d;
}


//
//   g e t B a n d
//

protected double[] getBand( TextField text )
    throws DataException

{
    double d[] = new double[2];
    String s = text.getText().trim();

    int k = s.indexOf( ";" );

    if( k < 0 )
        k = s.indexOf( "," );

    if( k < 0 ) {
        int k1 = s.indexOf( "/" );
        if( k1 >= 0 )  {
            String s1 = s.substring( 0, k1 ).trim();
            if( ! s1.equals( "+" ) && ! s1.equals( "-" ) )
                k = k1;
        }
    }

    if( k >= 0 ) {
        try { 
            d[0] = Double.valueOf( s.substring( 0, k ).trim() ).doubleValue();
            d[1] = Double.valueOf( s.substring( k + 1 ).trim() ).doubleValue();
        }
        catch( NumberFormatException e ) {
            setWrong( text );
            panic( "Not a valid number or band of numbers" );
        }
        if( d[0] > d[1] ) {
            double t = d[0];
            d[0] = d[1];
            d[1] = t;
        }
        if( d[0] > 0 || d[1] < 0 ) {
            setWrong( text );
            panic( "Not a valid number or band of numbers" );
        }
    }
    else {
        int sign = 0;
        double a = 0;

        if( s.startsWith( "+" ) ) {
            s = s.substring( 1 ).trim();
            if( s.startsWith( "/" ) ) {
                s = s.substring( 1 ).trim();
                if( s.startsWith( "-" ) ) {
                    s = s.substring( 1 ).trim();
                }
                else {
                    setWrong( text );
                    panic( "Not a valid number or band of numbers" );
                }
            }
            else
            if( s.startsWith( "-" ) ) {
                s = s.substring( 1 ).trim();
            }
            else {
                sign = +1;
            }
        }
        else
        if( s.startsWith( "-" ) ) {
            s = s.substring( 1 ).trim();
            if( s.startsWith( "/" ) ) {
                s = s.substring( 1 ).trim();
                if( s.startsWith( "+" ) ) {
                    s = s.substring( 1 ).trim();
                }
                else {
                    setWrong( text );
                    panic( "Not a valid number or band of numbers" );
                }
            }
            else
            if( s.startsWith( "+" ) ) {
                s = s.substring( 1 ).trim();
            }
            else {
                sign = -1;
            }
        }
        try { 
            a = Double.valueOf( s ).doubleValue();
        }
        catch( NumberFormatException e ) {
            setWrong( text );
            panic( "Not a valid number or band of numbers" );
        }
        if( a < 0 )
            a = -a;
        if( sign >= 0 )
            d[1] = a;
        else
            d[1] = 0;
        if( sign <= 0 )
            d[0] = -a;
        else
            d[0] = 0;
    }

    return d;
}


//
//   a d d
//

protected void add( Container container, Component component,
    GridBagConstraints constraints )

{
    container.add( component );
    ( (GridBagLayout) container.getLayout() ).setConstraints(
            component, constraints );
}


//
//   a d d
//

protected void add( Component component, GridBagConstraints constraints )
    

{
    add( this, component, constraints );
}


//
//   s e t W r o n g
//

protected void setWrong( Component comp )

{
    clearWrong();
    m_wrongComp = comp;
    m_wrongOldColor = m_wrongComp.getBackground();
    m_wrongComp.setBackground( Color.red );
}


//
//   s e t W r o n g
//

protected void setWrong( Component comp, String msg )
    throws DataException

{
    setWrong( comp );
    panic( msg );
}


//
//   s e t W r o n g
//

protected void setWrong( Component comp, DataException e )
    throws DataException

{
    setWrong( comp );
    panic( e );
}


//
//   c l e a r W r o n g
//

protected void clearWrong()

{
    if( m_wrongComp != null ) {
        Pool.m_status.setMsg( "" );
        m_wrongComp.setBackground( null );
        m_wrongComp = null;
    }
}


//
//   p a n i c
//

protected void panic()
    throws DataException

{
    m_wrongMsg = null;
    throw new DataException( "" );
}


//
//   p a n i c
//

protected void panic( String msg )
    throws DataException

{
    m_wrongMsg = msg;
    throw new DataException( msg );
}


//
//   p a n i c
//

protected void panic( DataException e )
    throws DataException

{
    String s = e.toString();
    panic( s.substring( s.indexOf( ":" ) + 1 ).trim() );
}

} // end of class
