// Copyright 1999, 2002 Robert Buff
// Contact: http://robertbuff.com/uvm
//
// This file is part of Mtg-Book.
//
// Mtg-Book is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2 of the License,
// or (at your option) any later version.
//
// Mtg-Book is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Mtg-Book; if not, write to the 
//
// Free Software Foundation, Inc.
// 59 Temple Place, Suite 330
// Boston, MA 02111-1307
// USA

package nom.rb.MtgClt;
import nom.rb.common.*;

import java.net.*;
import java.awt.*;


///////////////////////////////////////////////////////////////////

//
//   P o o l
//

public final class Pool {


//
//   v a r i a b l e s
//

    // parts available before initialization

public static final String m_title = 
    "MtgClt 2.0";

public static final String m_appletInfo =
    "MtgClt 2.0\n" +
    "(C) Robert Buff 2002\n" +
    "http://robertbuff.com/uvm";

public static final String m_aboutInfo =
    "MtgClt 2.0\n" +
    "(C) Robert Buff 2002\n" +
    "http://robertbuff.com/uvm";

    // parts available after initialization

public static URL m_homeUrl;
public static URL m_tutorialUrl;

public static String m_serverHost = "127.0.0.1";
public static int m_serverPort    = 12233;
public static int m_detourPort    = 12234;

public static boolean m_useProxy  = false;
public static String m_proxyHost  = "";
public static int m_proxyPort     = 8080;

public static MainFrame m_frame;
public static MainMenu m_menu;

public static Portfolio m_portfolio;
public static Scenario m_scenario;
public static Advanced m_advanced;
public static OneClick m_oneClick;
public static WorkSpace m_workSpace;

public static ResultGraph m_resultGraph;
public static ReportArea m_report;

public static Toolbar m_toolbar;
public static StatusLine m_status;

    // use an alternate background color for dialogs?

public static Color m_bgColor = Color.lightGray;

public static boolean m_standAlone;


//
//   i n i t
//

public static synchronized void init( MainFrame frame, MainMenu menu,
    boolean standAlone, String serverHost, String serverPort,
    String homeUrl, String tutorialPath )

{
    m_frame = frame;
    m_menu = menu;
    m_standAlone = standAlone;

    if( serverHost != null && serverHost.trim().length() > 0 )
        m_serverHost = serverHost.trim();

    if( serverPort != null ) {
        int port = -1;

        try {
            port = Integer.valueOf( serverPort.trim() ).intValue();
        }
        catch( NumberFormatException e ) {
        }

        if( port > 0 ) {
            m_serverPort = port;
            m_detourPort = m_serverPort + 1;
        }
    }

    try {  
        if( homeUrl != null && homeUrl.trim().length() > 0 )
            m_homeUrl = new URL( homeUrl );
        else
            m_homeUrl = new URL( "http://" + m_serverHost + "/mtg" );
        if( tutorialPath != null && tutorialPath.trim().length() > 0 )
            m_tutorialUrl = new URL( m_homeUrl + tutorialPath );
        else
            m_tutorialUrl = new URL( m_homeUrl + "/tutorial1.html" );
    }
    catch( MalformedURLException e ) {
        throw new InternalError();
    }

    m_resultGraph = new ResultGraph();
    m_report = new ReportArea( 100 );
    m_toolbar = new Toolbar();
    m_status = new StatusLine();

    m_portfolio = new Portfolio();
    m_scenario = new Scenario();
    m_advanced = new Advanced();
    m_oneClick = new OneClick();
    m_workSpace = new WorkSpace();
}


//
//   o k
//

public static int ok( String title, String msg )

{
    return MessageBox.ok( m_frame, title, msg );
}


//
//   o k C a n c e l
//

public static int okCancel( String title, String msg )

{
    return MessageBox.okCancel( m_frame, title, msg );
}


//
//   y e s N o C a n c e l
//

public static int yesNoCancel( String title, String msg )

{
    return MessageBox.yesNoCancel( m_frame, title, msg );
}

} // end of class
