// Copyright 1999, 2002 Robert Buff
// Contact: http://robertbuff.com/uvm
//
// This file is part of Mtg-Book.
//
// Mtg-Book is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2 of the License,
// or (at your option) any later version.
//
// Mtg-Book is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Mtg-Book; if not, write to the 
//
// Free Software Foundation, Inc.
// 59 Temple Place, Suite 330
// Boston, MA 02111-1307
// USA

package nom.rb.MtgClt;
import nom.rb.common.*;

import java.awt.*;


///////////////////////////////////////////////////////////////////

//
//   W o r k S p a c e
//

class WorkSpace extends Panel {


//
//   v a r i a b l e s
//

private CardLayout m_layout;

private ParamSpace m_current;

private Portfolio m_portfolio;
private Scenario m_scenario;
private Advanced m_advanced;
private OneClick m_oneClick;


//
//   W o r k S p a c e
//

public WorkSpace()

{
    m_portfolio = Pool.m_portfolio;
    m_scenario = Pool.m_scenario;
    m_advanced = Pool.m_advanced;
    m_oneClick = Pool.m_oneClick;

    m_layout = new CardLayout();
    setLayout( m_layout );

    add( m_portfolio.idToString(), createDialog( m_portfolio ) );
    add( m_scenario.idToString(), createDialog( m_scenario ) );
    add( m_advanced.idToString(), createDialog( m_advanced ) );
    add( m_oneClick.idToString(), createDialog( m_oneClick ) );

    activate( m_oneClick );
}


//
//   m i n i m u m S i z e
//
    
public Dimension minimumSize()

{
    return new Dimension( 0, 0 );
}


//
//   p r e f e r r e d S i z e
//

public Dimension preferredSize()

{
    return super.preferredSize();
}


//
//   a c t i v a t e
//

public void activate( ParamSpace space )

{
    if( m_current == null ||
        ( m_current == m_oneClick ) != ( space == m_oneClick ) ) {

        if( m_current == m_oneClick ) {
            m_oneClick.copyTo( m_portfolio, m_scenario, m_advanced );
            Pool.m_menu.wizardMode();
            Pool.m_toolbar.wizardMode();
        }
        else {
            m_oneClick.copyFrom( m_portfolio, m_scenario, m_advanced );
            Pool.m_menu.oneClickMode();
            Pool.m_toolbar.oneClickMode();
        }
    }

    m_current = space;
    m_current.adjustExampleMenu();
    m_layout.show( this, m_current.idToString() );
    m_current.requestFocus();
}


//
//   p o r t f o l i o
//

public void portfolio()

{
    activate( m_portfolio );
}


//
//   s c e n a r i o
//

public void scenario()

{
    activate( m_scenario );
}


//
//   a d v a n c e d
//

public void advanced()

{
    activate( m_advanced );
}


//
//   o n e C l i c k
//

public void oneClick()

{
    if( m_current == m_oneClick )
        activate( m_portfolio );
    else
        activate( m_oneClick );
}


//
//   c l e a r
//

public void clear()

{
    m_portfolio.clear();
    m_scenario.clear();
    m_advanced.clear();
    m_oneClick.clear();
    Pool.m_report.clear();
}


//
//   r e s e t
//

public void reset()

{
    m_current.clear();
}


//
//   e x a m p l e
//

public void example( int num )

{
    m_current.example( num );
}


//
//   g e n R e q u e s t
//

public String genRequest()

{
    if( m_current == m_oneClick ) {
        try {
            m_oneClick.prepare();
        }
        catch( DataException e ) {
            return null;
        }

        return m_oneClick.protOneClick();
    }
    else {
        try {
            m_portfolio.prepare();
        }
        catch( DataException e ) {
            activate( m_portfolio );
            m_portfolio.showWrong();
            return null;
        }

        try {
            m_scenario.prepare( m_portfolio );
        }
        catch( DataException e ) {
            activate( m_scenario );
            m_scenario.showWrong();
            return null;
        }

        try {
            m_advanced.prepare( m_portfolio, m_scenario );
        }
        catch( DataException e ) {
            activate( m_advanced );
            m_advanced.showWrong();
            return null;
        }

        return m_scenario.protScenario( m_advanced ) + 
               m_portfolio.protPortfolio() +
               m_advanced.protAdvanced( m_scenario );
    }
}


//
//   p a r a m T i m e s t e p
//

public int[] paramTimestep()

{
    if( m_current == m_oneClick )
        return m_oneClick.paramTimestep();
    return m_advanced.paramTimestep();
}


//
//   p a r a m S e l l e r
//

public boolean paramSeller()

{
    if( m_current == m_oneClick )
        return m_oneClick.paramSeller();
    return m_scenario.paramSeller();
}


//
//   p a r a m B u y e r
//

public boolean paramBuyer()

{
    if( m_current == m_oneClick )
        return m_oneClick.paramBuyer();
    return m_scenario.paramBuyer();
}


//
//   p a r a m I s U n c e r t a i n
//

public boolean paramIsUncertain()

{
    if( m_current == m_oneClick )
        return m_oneClick.paramIsUncertain();
    return m_scenario.paramIsUncertain();
}


//
//   p a r a m S p o t P r i c e
//

public double paramSpotPrice()

{
    if( m_current == m_oneClick )
        return m_oneClick.paramSpotPrice();
    return m_scenario.paramSpotPrice();
}


//
//   c r e a t e D i a l o g
//

private Panel createDialog( Component comp )

{
    TrivialLayout layout = new TrivialLayout( 15, 15 );

    Panel frame = new Panel();
    frame.setLayout( layout );

    if( Pool.m_bgColor != null )
        frame.setBackground( Pool.m_bgColor );

    frame.add( "", comp );

    return frame;
}

} // end of class
