// Copyright 1999, 2002 Robert Buff
// Contact: http://robertbuff.com/uvm
//
// This file is part of Mtg-Book.
//
// Mtg-Book is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2 of the License,
// or (at your option) any later version.
//
// Mtg-Book is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Mtg-Book; if not, write to the 
//
// Free Software Foundation, Inc.
// 59 Temple Place, Suite 330
// Boston, MA 02111-1307
// USA

package nom.rb.common;

import java.net.*;
import java.io.*;


///////////////////////////////////////////////////////////////////

//
//   C o n t e n t T e x t
//

public class ContentTextPlain extends ContentHandler {

    
//
//   g e t C o n t e n t
//
    
public Object getContent( URLConnection conn )

{
	try {
	    InputStream input = conn.getInputStream();
	    StringBuffer buffer = new StringBuffer();

	    Thread curThread = Thread.currentThread();
	    
        int c;
	    while( ( c = input.read() ) >= 0 ) {
		    if( curThread.interrupted() ) {
		        input.close();
		        return null;
		    }
		    buffer.append( (char) c );
	    }
	    input.close();
	    return buffer.toString();
	}
    catch( IOException e ) {
	    return null;
	}
}

} // end of class
