// Copyright 1999, 2002 Robert Buff
// Contact: http://robertbuff.com/uvm
//
// This file is part of Mtg-Book.
//
// Mtg-Book is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2 of the License,
// or (at your option) any later version.
//
// Mtg-Book is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Mtg-Book; if not, write to the 
//
// Free Software Foundation, Inc.
// 59 Temple Place, Suite 330
// Boston, MA 02111-1307
// USA

package nom.rb.common;

import java.awt.*;


///////////////////////////////////////////////////////////////////

//
//   E x t B u t t o n
//

public class ExtButton extends Button {


//
//   v a r i a b l e s
//

private int m_id;
private String m_width;


//
//   E x t B u t t o n
//

public ExtButton( int id, String label )

{
    super( label );
    m_id = id;
}


//
//   E x t B u t t o n
//

public ExtButton( int id, String label, String width )

{
    this( id, label );
    setWidth( width );
}


//
//   s e t W i d t h
//

public void setWidth( String width )

{
    m_width = width;
}


//
//   i d
//

public int id()

{
    return m_id;
}
 
   
//
//   m i n i m u m S i z e
//
    
public Dimension minimumSize()

{
    if( m_width == null )
        return super.minimumSize();

    FontMetrics f = getFontMetrics( getFont() );

    return new Dimension(
        f.stringWidth( m_width ) + 1,
        super.minimumSize().height );
}


//
//   p r e f e r r e d S i z e
//

public Dimension preferredSize()

{
    if( m_width == null )
        return super.preferredSize();
    return minimumSize();
}

} // end of class
