///////////////////////////////////////////////////////////////
//
// MosaicConstraints.java 1.0 97/02/05 Robert Buff buff@cs.nyu.edu
//
// Copyright (c) 1997 Robert Buff. All Rights Reserved.
//
// You may use, copy, modify, and distribute this software
// for NON-COMMERCIAL purposes and without fee provided that
// this copyright notice appears in all copies. If you would
// like to use this software for COMMERCIAL purposes, contact
// the author and we will work something out.
//
// It would also be nice to give credit to the author in the
// Help/About dialog window of any application that uses this
// software.
//
///////////////////////////////////////////////////////////////

package nom.rb.common;

import java.awt.Insets;

///////////////////////////////////////////////////////////////
//
//   M o s a i c C o n s t r a i n t s
//
///////////////////////////////////////////////////////////////

public class MosaicConstraints extends Object implements Cloneable
{
  //
  //   C o n s t a n t s   f o r   m _ a n c h o r
  //

  public final static int CENTER    = 0;
  public final static int EAST      = 1;
  public final static int NORTH     = 2;
  public final static int NORTHEAST = 3;
  public final static int NORTHWEST = 4;
  public final static int SOUTH     = 5;
  public final static int SOUTHEAST = 6;
  public final static int SOUTHWEST = 7;
  public final static int WEST      = 9;

  //
  //   C o n s t a n t s   f o r   m _ f i l l
  //

  public final static int HORIZONTAL = 0;
  public final static int VERTICAL   = 1;
  public final static int BOTH       = 2;
  public final static int NONE       = 3;

  public int m_anchor;
  public int m_fill;
  public double m_weightx;
  public double m_weighty;
  public Insets m_insets;

  //
  //   M o s a i c C o n s t r a i n t s
  //

  public MosaicConstraints()
  {
    this( CENTER, BOTH );
  }

  //
  //   M o s a i c C o n s t r a i n t s
  //

  public MosaicConstraints( int anchor, int fill )
  {
    this( anchor, fill, 1, 1 );
  }

  //
  //   M o s a i c C o n s t r a i n t s
  //

  public MosaicConstraints( int anchor, int fill, double weight )
  {
    this( anchor, fill, weight, weight );
  }

  //
  //   M o s a i c C o n s t r a i n t s
  //

  public MosaicConstraints( int anchor, int fill,
    double weightx, double weighty )
  {
    this( anchor, fill, weightx, weighty, new Insets( 0, 0, 0, 0 ) );
  }

  //
  //   M o s a i c C o n s t r a i n t s
  //

  public MosaicConstraints( int anchor, int fill, double weightx,
    double weighty, Insets insets )
  {
    m_anchor = anchor;
    m_fill = fill;
    m_weightx = weightx;
    m_weighty = weighty;
    m_insets = insets;
  }

  //
  //   c l o n e
  //

  public Object clone()
  {
    Insets insets =
      (Insets) ( m_insets == null ? null : m_insets.clone() );

    return new MosaicConstraints( m_anchor, m_fill, m_weightx,
      m_weighty, insets );
  }
}
