///////////////////////////////////////////////////////////////
//
// MosaicCoordStack.java 1.0 97/02/05 Robert Buff buff@cs.nyu.edu
//
// Copyright (c) 1997 Robert Buff. All Rights Reserved.
//
// You may use, copy, modify, and distribute this software
// for NON-COMMERCIAL purposes and without fee provided that
// this copyright notice appears in all copies. If you would
// like to use this software for COMMERCIAL purposes, contact
// the author and we will work something out.
//
// It would also be nice to give credit to the author in the
// Help/About dialog window of any application that uses this
// software.
//
///////////////////////////////////////////////////////////////

package nom.rb.common;

import java.util.Enumeration;
import java.util.Stack;

import nom.rb.common.MosaicCoord;

///////////////////////////////////////////////////////////////
//
//   M o s a i c C o o r d S t a c k
//
///////////////////////////////////////////////////////////////

public class MosaicCoordStack extends Object implements Cloneable
{
  private Stack m_stack;

  //
  //   M o s a i c C o o r d S t a c k
  //

  public MosaicCoordStack()
  {
    m_stack = new Stack();
  }

  //
  //   r e s e t
  //

  public void reset()
  {
    m_stack.removeAllElements();
  }

  //
  //   p u s h P o s
  //

  public void pushPos( int col, int row )
  {
    m_stack.push( new MosaicCoord( col, row ) );
  }

  //
  //   p u s h P o s
  //

  public void pushPos( MosaicCoord coord )
  {
    m_stack.push( coord.clone() );
  }

  //
  //   p o p P o s
  //

  public void popPos()
  {
    try {
      m_stack.pop();
    }
    catch( Exception e ) {
    }
  }

  //
  //   s e t P o s
  //

  public void setPos( int col, int row )
  {
    reset();
    pushPos( col, row );
  }

  //
  //   s e t P o s
  //

  public void setPos( MosaicCoord coord )
  {
    reset();
    pushPos( coord );
  }

  //
  //   s e t P o s
  //

  public void setPos( int col1, int row1, int col2, int row2 )
  {
    setPos( col1, row1 );
    pushPos( col2, row2 );
  }

  //
  //   s e t P o s
  //

  public void setPos( MosaicCoord coord1, MosaicCoord coord2 )
  {
    setPos( coord1 );
    pushPos( coord2 );
  }

  //
  //   n e x t C o l
  //

  public void nextCol()
  {
    try {
      MosaicCoord c = (MosaicCoord) m_stack.pop();
      ++c.m_col;
      m_stack.push( c );
    }
    catch( Exception e ) {
    }
  }

  //
  //   n e x t R o w
  //

  public void nextRow()
  {
    try {
      MosaicCoord c = (MosaicCoord) m_stack.pop();
      ++c.m_row;
      c.m_col = 0;
      m_stack.push( c );
    }
    catch( Exception e ) {
    }
  }

  //
  //   t o S t r i n g
  //

  public String toString()
  {
    Enumeration E = elements();
    String s = "";

    while( E.hasMoreElements() ) {
      s += E.nextElement().toString();
    }

    return s;
  }

  //
  //   c l o n e
  //

  public Object clone()
  {
    MosaicCoordStack p = new MosaicCoordStack();
    p.m_stack = (Stack) m_stack.clone();
    return p;
  }

  //
  //   e l e m e n t s
  //

  protected Enumeration elements()
  {
    return m_stack.elements();
  }
}
