// Copyright 1999, 2002 Robert Buff
// Contact: http://robertbuff.com/uvm
//
// This file is part of Mtg-Book.
//
// Mtg-Book is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2 of the License,
// or (at your option) any later version.
//
// Mtg-Book is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Mtg-Book; if not, write to the 
//
// Free Software Foundation, Inc.
// 59 Temple Place, Suite 330
// Boston, MA 02111-1307
// USA

///////////////////////////////////////////////////////////////
//
// MosaicPanel.java 1.0 97/02/05 Robert Buff buff@cs.nyu.edu
//
// Copyright (c) 1997 Robert Buff. All Rights Reserved.
//
// You may use, copy, modify, and distribute this software
// for NON-COMMERCIAL purposes and without fee provided that
// this copyright notice appears in all copies. If you would
// like to use this software for COMMERCIAL purposes, contact
// the author and we will work something out.
//
// It would also be nice to give credit to the author in the
// Help/About dialog window of any application that uses this
// software.
//
///////////////////////////////////////////////////////////////
//
// Use a MosaicPanel object instead of a regular Panel object
// if you want to use the MosaicLayout layout manager (it
// works with regular panels, too, but not at full speed).
// The usage of a MosaicPanel does not differ from the usage
// of a regular Panel.  MosaicPanel redirects some events to
// the layout manager, and takes care that the sashes are
// painted when necessary (they are painted on the MosaicPanel).
//
///////////////////////////////////////////////////////////////

package nom.rb.common;

import java.awt.*;
import java.util.*;

import nom.rb.common.MosaicLayout;

///////////////////////////////////////////////////////////////
//
//   M o s a i c P a n e l
//
///////////////////////////////////////////////////////////////

public class MosaicPanel extends Panel
{
  private boolean m_propagateInvalidate = true;

  //
  //   h a n d l e E v e n t
  //

  public boolean handleEvent( Event evt ) 
  {
    LayoutManager layout = getLayout();

    if( layout instanceof MosaicLayout ) {
      if( ( (MosaicLayout) layout ).handleEvent( evt ) )
        return true;
    }

    return super.handleEvent( evt );
  }

  //
  //   u p d a t e
  //

  public void update( Graphics g )
  {
    LayoutManager layout = getLayout();
    if( layout instanceof MosaicLayout )
      paint( g );
    else
      super.update( g );
  }

  //
  //   p a i n t
  //

  public void paint( Graphics g )
  {
    LayoutManager layout = getLayout();
    if( layout instanceof MosaicLayout )
      ( (MosaicLayout) layout ).paint( g );
    else
      super.paint( g );
  }

  //
  //   i n v a l i d a t e
  //

  public void invalidate()
  {
    if( m_propagateInvalidate )
      super.invalidate();
  }

  //
  //   p r o p a g a t e I n v a l i d a t e
  //

  public void propagateInvalidate()
  {
    m_propagateInvalidate = true;
  }

  //
  //   d o n t P r o p a g a t e I n v a l i d a t e
  //

  public void dontPropagateInvalidate()
  {
    m_propagateInvalidate = false;
  }
}
