// Copyright 1999, 2002 Robert Buff
// Contact: http://robertbuff.com/uvm
//
// This file is part of Mtg-Book.
//
// Mtg-Book is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2 of the License,
// or (at your option) any later version.
//
// Mtg-Book is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Mtg-Book; if not, write to the 
//
// Free Software Foundation, Inc.
// 59 Temple Place, Suite 330
// Boston, MA 02111-1307
// USA

package nom.rb.common;

import java.awt.*;
import java.util.*;

///////////////////////////////////////////////////////////////////

//
//   M u l t i L i n e L a b e l
//

public class MultiLineLabel extends Panel {


//
//   v a r i a b l e s
//

public static final int LEFT = -1;
public static final int CENTER = 0;
public static final int RIGHT = 1;

private int m_marginWidth;
private int m_marginHeight;

private String[] m_line;
private int m_numOfLines;


//
//   M u l t i L i n e L a b e l
//

public MultiLineLabel( String label, int marginWidth, int marginHeight,
    int align )

{
    splitLabel( label );

    m_marginWidth = marginWidth;
    m_marginHeight = marginHeight;

    GridBagLayout layout = new GridBagLayout();
    setLayout( layout );

    GridBagConstraints c = new GridBagConstraints();

    c.gridx = 0;
    if( m_numOfLines == 1 ) {
        c.insets = new Insets( marginHeight, marginWidth,
            marginHeight, marginWidth );
    }
    else {
        c.insets = new Insets( marginHeight, marginWidth, 0, marginWidth );
    }

    switch( align ) {
        case LEFT  : c.anchor = GridBagConstraints.WEST;   break;
        case RIGHT : c.anchor = GridBagConstraints.EAST;   break;
        default    : c.anchor = GridBagConstraints.CENTER; break;
    }

    if( m_numOfLines >= 1 ) {
        Label l = new Label( m_line[0] );
        add( l );
        layout.setConstraints( l, c );

        if( m_numOfLines >= 2 ) {
            c.insets = new Insets( 0, marginWidth, 0, marginWidth );
            for( int k = 1; k < m_numOfLines - 1; ++k ) {
                l = new Label( m_line[k] );
                add( l );
                layout.setConstraints( l, c );
            }

            c.insets = new Insets( 0, marginWidth,
                marginHeight, marginWidth );
            l = new Label( m_line[m_numOfLines - 1] );
            add( l );
            layout.setConstraints( l, c );
        }
    }
}


//
//   M u l t i L i n e L a b e l
//

public MultiLineLabel( String label, int marginWidth, int marginHeight )

{
    this( label, marginWidth, marginHeight, CENTER );
}


//
//   M u l t i L i n e L a b e l
//

public MultiLineLabel( String label, int align )

{
    this( label, 10, 10, align );
}


//
//   M u l t i L i n e L a b e l
//

public MultiLineLabel( String label )

{
    this( label, 10, 10, CENTER );
}


//
//   s p l i t L a b e l
//

private void splitLabel( String label )

{
    StringTokenizer t = new StringTokenizer( label, "\n" );

    m_numOfLines = t.countTokens();

    m_line = new String[m_numOfLines];
    for( int i = 0; i < m_numOfLines; ++i )
        m_line[i] = t.nextToken();
}

} // end of class
