// Copyright 1999, 2002 Robert Buff
// Contact: http://robertbuff.com/uvm
//
// This file is part of Mtg-Book.
//
// Mtg-Book is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2 of the License,
// or (at your option) any later version.
//
// Mtg-Book is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Mtg-Book; if not, write to the 
//
// Free Software Foundation, Inc.
// 59 Temple Place, Suite 330
// Boston, MA 02111-1307
// USA

package nom.rb.common;

import java.awt.*;
import java.io.*;

///////////////////////////////////////////////////////////////////

//
//   P u b l i c T e x t
//

public class PublicText extends TextArea {


//
//   v a r i a b l e s
//

private boolean m_hasFocus = false;

protected String m_file = null;

private boolean m_canChangeFont = false;
private boolean m_tryFixedFont = false;

private static final String[] m_fixedFont = {
    "System",
    "Courier",
    "Monospaced"
};


//
//   f i l e
//

public String file()

{
    return m_file;
}


//
//   a d d N o t i f y
//

public void addNotify()

{
    super.addNotify();
    m_canChangeFont = true;
    if( m_tryFixedFont ) {
        tryFixedFont();
        m_tryFixedFont = false;
    }
}


//
//   t r y F i x e d F o n t
//
    
public boolean tryFixedFont()

{
    if( ! m_canChangeFont ) {
        m_tryFixedFont = true;
        return false;
    }
    
    String[] font = Toolkit.getDefaultToolkit().getFontList();

    for( int k = 0; k < m_fixedFont.length; ++k ) {
        for( int i = 0; i < font.length; ++i ) {
            if( font[i].equalsIgnoreCase( m_fixedFont[k] ) ) {
                Font f = getFont();

                if( f != null ) {
                    setFont( new Font( m_fixedFont[k],
                                f.getStyle(), f.getSize() ) );
                    return true;
                }

                f = Font.getFont( m_fixedFont[k] );
                if( f != null ) {
                    setFont( f );
                    return true;
                }
            }
        }
    }
    return false;
}


//
//   s a v e
//

public boolean save()

{
    String file;

    try {        
        file = checkFile( m_file );
    }
    catch( IOException e ) {
        return saveAs();
    }

    Frame parent = parent();

    try {        
        writeToFile( m_file, getText() );
    }
    catch( IOException e ) {
        MessageBox.ok( parent, "Error", "File cannot be written" );
        return false;
    }

    return true;
}

   
//
//   s a v e A s
//

public boolean saveAs()

{
    Frame parent = parent();

    FileDialog dialog =
        new FileDialog( parent, "Save As", FileDialog.SAVE );

    if( m_file != null )
        dialog.setFile( m_file );

    dialog.show();

    String file = dialog.getFile();

    if( file == null )
        return false;

    try {
        saveAs( file );
    }
    catch( IOException e ) {
        MessageBox.ok( parent, "Error", "File cannot be written" );
        return false;
    }

    return true;
}


//
//   s a v e A s
//

public void saveAs( String file )
    throws IOException

{
    file = checkFile( file );
    writeToFile( file, getText() );
    m_file = file;
}


//
//   c o p y
//

public String copy()

{
    return getSelectedText();
}


//
//   c o p y T o
//

public boolean copyTo()

{
    Frame parent = parent();

    FileDialog dialog =
        new FileDialog( parent, "Copy to", FileDialog.SAVE );

    dialog.show();

    String file = dialog.getFile();

    if( file == null )
        return false;

    try {
        copyTo( file );
    }
    catch( IOException e ) {
        MessageBox.ok( parent, "Error", "File cannot be written" );
        return false;
    }

    return true;
}


//
//   c o p y T o
//

public void copyTo( String file )
    throws IOException

{
    writeToFile( checkFile( file ), copy() );
}


//
//   g o t F o c u s
//

public boolean gotFocus( Event evt, Object what )

{
    m_hasFocus = true;
    return super.gotFocus( evt, what );
}


//
//   l o s t F o c u s
//

public boolean lostFocus( Event evt, Object what )

{
    m_hasFocus = false;
    return super.lostFocus( evt, what );
}


//
//   h a s F o c u s
//

public boolean hasFocus()

{
    return m_hasFocus;
}


//
//   c h e c k F i l e
//

protected String checkFile( String file )
    throws IOException

{
    if( file == null )
        throw new IOException();
    file = file.trim();
    if( file.length() == 0 ) 
        throw new IOException();
    return file;
}


//
//   p a r e n t
//

protected Frame parent()

{
    Component comp = getParent();
    while( comp != null && ! ( comp instanceof Frame ) )
        comp = comp.getParent();
    if( comp != null )
        return (Frame) comp;
    return null;
}


//
//   w r i t e T o F i l e
//

static protected void writeToFile( String file, String text )
    throws IOException

{
    try {
        FileOutputStream fout = new FileOutputStream( file );
        DataOutputStream dout = new DataOutputStream( fout );
        dout.writeBytes( text );
    }
    catch( SecurityException e ) {
        throw new IOException( "security" );
    }
    catch( IOException e ) {
        throw e;    // pass it on
    }
}

} // end of class
