// Copyright 1999, 2002 Robert Buff
// Contact: http://robertbuff.com/uvm
//
// This file is part of Mtg-Book.
//
// Mtg-Book is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2 of the License,
// or (at your option) any later version.
//
// Mtg-Book is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Mtg-Book; if not, write to the 
//
// Free Software Foundation, Inc.
// 59 Temple Place, Suite 330
// Boston, MA 02111-1307
// USA

package nom.robertbuff;

import java.awt.*;
import java.util.*;
import java.net.*;
import java.io.*;

///////////////////////////////////////////////////////////////////

//
//   T e x t E d i t o r
//

public class TextEditor extends PublicText {

    
//
//   v a r i a b l e s
//

public final static int LOCAL  = 0;
public final static int REMOTE = 1;

private int m_source = 0;

private URL m_url;


//
//   T e x t E d i t o r
//

public TextEditor()

{
    super();
    tryFixedFont();
}


//
//   c l e a r
//

public void clear()

{
    m_source = LOCAL;
    m_file = "";
    setText( "" );
}


//
//   o p e n
//
    
public void open( URL url )
    throws IOException

{
    try {
        setText( readFromURL( url ) );
    }
    catch( SecurityException e ) {
        throw new IOException();
    }
    m_source = REMOTE;
    m_url = url;
    m_file = null;
}


//
//   o p e n
//

public void open( String file )
    throws IOException

{
    file = checkFile( file );
    setText( readFromFile( file ) );
    m_source = LOCAL;
    m_file = file;
    m_url = null;
}


//
//   o p e n
//

public boolean open()

{
    Frame parent = parent();

    FileDialog dialog =
        new FileDialog( parent, "Open", FileDialog.LOAD );

    dialog.setFile( m_file );
    dialog.show();

    String file = dialog.getFile();

    if( file == null )
        return false;

    try {
        open( file );
    }
    catch( IOException e ) {
        MessageBox.ok( parent, "Error", "File not found" );
        return false;
    }

    return true;
}


//
//   s a v e
//

public boolean save()

{
    if( super.save() ) {
        m_source = LOCAL;
        return true;
    }
    return false;
}


//
//   s a v e A s
//

public boolean saveAs()

{
    if( super.saveAs() ) {
        m_source = LOCAL;
        return true;
    }
    return false;
}


//
//   s a v e A s
//

public void saveAs( String file )
    throws IOException

{
    super.saveAs( file );
    m_source = LOCAL;
}


//
//   p a s t e
//

public void paste( Object text )

{
    replaceText( text.toString(),
        getSelectionStart(), getSelectionEnd() );
}


//
//   p a s t e F r o m
//

public void pasteFrom( URL url )
    throws IOException

{
    try {
        paste( readFromURL( url ) );
    }
    catch( SecurityException e ) {
        throw new IOException();
    }
}


//
//   p a s t e F r o m
//

public void pasteFrom( String file )
    throws IOException

{
    paste( readFromFile( checkFile( file ) ) );
}


//
//   c u t
//

public String cut()

{
    String text = getSelectedText();
    int start = getSelectionStart();
    replaceText( "", start, getSelectionEnd() );
    setSelectionEnd( start );
    return text;
}


//
//   c u t T o
//

public void cutTo( String file )
    throws IOException

{
    writeToFile( checkFile( file ), copy() );
    cut();
}


//
//   r e a d F r o m U R L
//

static private String readFromURL( URL url )
    throws IOException

{
    Object obj;

    try {
        obj = url.getContent();
    }
    catch( IOException e ) {
        throw e;    // pass it on
    }

    if( obj instanceof String )
        return (String) obj;
    throw new UnknownServiceException();
}


//
//   r e a d F r o m F i l e
//

static private String readFromFile( String file )
    throws IOException

{
    try {
        FileInputStream fin = new FileInputStream( file );
        DataInputStream din = new DataInputStream( fin );

        String text = new String();
        while( din.available() > 0 )
            text += din.readLine() + "\n";

        return text;
    }
    catch( IOException e ) {
        throw e;    // pass it on
    }
}

} // end of class
