// Copyright 1999, 2002 Robert Buff

// Contact: http://robertbuff.com/uvm

//

// This file is part of Mtg-Book.

//

// Mtg-Book is free software; you can redistribute it and/or modify

// it under the terms of the GNU General Public License as published

// by the Free Software Foundation; either version 2 of the License,

// or (at your option) any later version.

//

// Mtg-Book is distributed in the hope that it will be useful,

// but WITHOUT ANY WARRANTY; without even the implied warranty of

// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the

// GNU General Public License for more details.

//

// You should have received a copy of the GNU General Public License

// along with Mtg-Book; if not, write to the 

//

// Free Software Foundation, Inc.

// 59 Temple Place, Suite 330

// Boston, MA 02111-1307

// USA



#if ! defined(_MTG_BSMODEL_)

#define _MTG_BSMODEL_



#include "MtgModel.h"



MTG_BEGIN_NAMESPACE



class tDrift;

class tParser;

class tPortfolio;

class tVol;





//

//   t B S M o d e l

//



class tBSModel : public tModel {



    typedef tModel super;



    tDrift* m_pDiscount;   // reference

    tDrift* m_pCarry;      // reference  

    tDrift* m_pMu;         // owned 



    tVol* m_pVol;          // reference 



    double m_gRoot;



        // The scale is for the volatility and drift parameters.

        // If day is chosen, everything is scaled down to the

        // base unit "day", which is more logical, but requires

        // one more transformation. (Only the calculations are

        // in to the desired scale! Everything else is stored

        // day-based.)



    tScale m_nScale;



    void init();

    void copyFrom( const tBSModel& Model );



    tRetCode parseParam( tParser& Parser, tParseInfoStub& Info );

    tRetCode parsePostfix( tParser& Parser, tParseInfoStub& Info );



public:



    tBSModel();

    tBSModel( const tBSModel& Model );



    ~tBSModel();



    tBSModel& operator=( const tBSModel& Model );



    tObject* clone() const;



    tRetCode finalize();



    tScale scale() const {

        return m_nScale;

    }



    void getDrift( int nFromDay, int nToDay, double& gDiscount,

        double& gMu ) const;



    void getVol( int nFromDay, int nToDay, double& gPrior, double& gMin,

        double& gMax ) const;



    bool isLinear( int nDay ) const;



    tRetCode createSpaceAxis( tFDMethod nMethod, double gMaxDt,

        tHeap<tSpaceAxis*>& Space, const tPortfolio* pPf = 0 );



    tRetCode createEngine( const tScenario* pScenario,

        tFDEngine*& pEngine, tAccuracy m_nAccuracy );

};



MTG_END_NAMESPACE



#endif

