// Copyright 1999, 2002 Robert Buff

// Contact: http://robertbuff.com/uvm

//

// This file is part of Mtg-Book.

//

// Mtg-Book is free software; you can redistribute it and/or modify

// it under the terms of the GNU General Public License as published

// by the Free Software Foundation; either version 2 of the License,

// or (at your option) any later version.

//

// Mtg-Book is distributed in the hope that it will be useful,

// but WITHOUT ANY WARRANTY; without even the implied warranty of

// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the

// GNU General Public License for more details.

//

// You should have received a copy of the GNU General Public License

// along with Mtg-Book; if not, write to the 

//

// Free Software Foundation, Inc.

// 59 Temple Place, Suite 330

// Boston, MA 02111-1307

// USA



#if ! defined(_MTG_CGI_)

#define _MTG_CGI_



#include "MtgHeap.h"



#if defined(_MTG_WITH_CGI)





MTG_BEGIN_NAMESPACE





//

//   t C g i

//



class tCgi {



    static bool m_bIsInitialized;



    static void trim( char* sValue );



public:



        // Check whether we're dealing with a CGI call:



    static bool isActive();



        // Must call init() before the CGI handler is used.



    static tRetCode init();

    static tRetCode init( const char* sEnvFile );



    static void exit();



        // Debugging.



    static void readState( const char* sFileName = "c:\\temp\\cgi.env" );

    static void writeState( const char* sFileName = "c:\\temp\\cgi.env" );



        // Read variables.



        // First, environment variables. These functions return "",

        // not 0, if the variable is not provided.



    static const char* getServerSoftware();

    static const char* getServerName();

    static const char* getGatewayInterface();

    static const char* getServerProtocol();

    static const char* getServerPort();

    static const char* getRequestMethod();

    static const char* getPathInfo();

    static const char* getPathTranslated();

    static const char* getScriptName();

    static const char* getQueryString();

    static const char* getRemoteHost();

    static const char* getRemoteAddr();

    static const char* getAuthType();

    static const char* getRemoteUser();

    static const char* getRemoteIdent();

    static const char* getContentType();

    static const char* getAccept();

    static const char* getUserAgent();

    

        // Allocate memory for sValue:



    static tRetCode getVar( const char* sName, char*& sValue,

        bool bTrim = true );



    static tRetCode getVar( const char* sName, tDate& Value );

    static tRetCode getVar( const char* sName, tDate& Value, tDate Default );



    static tRetCode getVar( const char* sName, int& nValue );

    static tRetCode getVar( const char* sName, int& nValue, int nDefault );



    static tRetCode getVar( const char* sName, double& gValue );

    static tRetCode getVar( const char* sName, double& gValue,

        double gDefault );



        // Single selects, check boxes and radio controls:



    static tRetCode getVar( const char* sName, int& nIndex,

        const tHeap<char*>& Candidates );



    static tRetCode getVar( const char* sName, int& nIndex,

        const tHeap<char*>& Candidates, int nDefault ); 



    static tRetCode getVar( const char* sName, int& nIndex,

        const char* sCand0, const char* sCand1 );



    static tRetCode getVar( const char* sName, int& nIndex,

        const char* sCand0, const char* sCand1, int nDefault ); 



        // Write HTML code:



    static tRetCode outHeaderContentType( const char* sType = "text",

        const char* sSubType = "html" );



    static tRetCode out( const char* sFmt, ... );

};



MTG_END_NAMESPACE



#endif



#endif

