// Copyright 1999, 2002 Robert Buff

// Contact: http://robertbuff.com/uvm

//

// This file is part of Mtg-Book.

//

// Mtg-Book is free software; you can redistribute it and/or modify

// it under the terms of the GNU General Public License as published

// by the Free Software Foundation; either version 2 of the License,

// or (at your option) any later version.

//

// Mtg-Book is distributed in the hope that it will be useful,

// but WITHOUT ANY WARRANTY; without even the implied warranty of

// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the

// GNU General Public License for more details.

//

// You should have received a copy of the GNU General Public License

// along with Mtg-Book; if not, write to the 

//

// Free Software Foundation, Inc.

// 59 Temple Place, Suite 330

// Boston, MA 02111-1307

// USA



#include "MtgIncl.h"

#include "MtgColor.h"



MTG_BEGIN_NAMESPACE





//

//   o b j e c t s

//



tColor Black( 0, 0, 0 );

tColor White( 255, 255, 255 );

tColor Gray( 200, 200, 200 );

tColor Red( 255, 0, 0 );

tColor Green( 0, 255, 0 );

tColor Blue( 0, 0, 255 );





//

//   t C o l o r

//



tColor::tColor()



{

    m_R = 255;    // white is the default

    m_G = 255;

    m_B = 255;

}





//

//   t C o l o r

//



tColor::tColor( int R, int G, int B )



{

    MTG_ASSERT( 0 <= R && R <= 255 );

    MTG_ASSERT( 0 <= G && G <= 255 );

    MTG_ASSERT( 0 <= B && B <= 255 );



    m_R = R;

    m_G = G;

    m_B = B;

}





//

//   t C o l o r

//



tColor::tColor( const tColor& Color )



{

    m_R = Color.m_R;

    m_G = Color.m_G;

    m_B = Color.m_B;

}





//

//   o p e r a t o r =

//



tColor& tColor::operator=( const tColor& Color )



{

    m_R = Color.m_R;

    m_G = Color.m_G;

    m_B = Color.m_B;

    return *this;

}





//

//   o p e r a t o r = =

//



bool tColor::operator==( const tColor& Color )



{

    return m_R == Color.m_R &&

           m_G == Color.m_G &&

           m_B == Color.m_B;

}





//

//   o p e r a t o r ! =

//



bool tColor::operator!=( const tColor& Color )



{

    return m_R != Color.m_R ||

           m_G != Color.m_G ||

           m_B != Color.m_B;

}





//

//   a l l o c a t e

//



int tColor::allocate( gdImagePtr Ptr ) const



{

    int c = gdImageColorExact( Ptr, m_R, m_G, m_B );



    if( c >= 0 )

        return c;

    return gdImageColorAllocate( Ptr, m_R, m_G, m_B );

}



MTG_END_NAMESPACE