// Copyright 1999, 2002 Robert Buff

// Contact: http://robertbuff.com/uvm

//

// This file is part of Mtg-Book.

//

// Mtg-Book is free software; you can redistribute it and/or modify

// it under the terms of the GNU General Public License as published

// by the Free Software Foundation; either version 2 of the License,

// or (at your option) any later version.

//

// Mtg-Book is distributed in the hope that it will be useful,

// but WITHOUT ANY WARRANTY; without even the implied warranty of

// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the

// GNU General Public License for more details.

//

// You should have received a copy of the GNU General Public License

// along with Mtg-Book; if not, write to the 

//

// Free Software Foundation, Inc.

// 59 Temple Place, Suite 330

// Boston, MA 02111-1307

// USA



#include "MtgIncl.h"

#include "MtgCouponCashflow.h"



MTG_BEGIN_NAMESPACE





//

//   c o p y F r o m

//



void tCouponCashflow::copyFrom( const tCouponCashflow& CC )



{

    if( &CC == this )

        return;



    m_gCoupon = CC.m_gCoupon;

    super::copyFrom( CC );

}





//

//   g e n e r a t e

//



double tCouponCashflow::generate( tEngine& Engine, const tClaim& Claim )



{

    return m_gCoupon;

}





//

//   t C o u p o n C a s h f l o w

//



tCouponCashflow::tCouponCashflow( tSystem& System,

    int nDay, double gCoupon )

    : tCashflow( System, nDay )



{

    m_gCoupon = gCoupon;

}





//

//   t C o u p o n C a s h f l o w

//



tCouponCashflow::tCouponCashflow( tSystem& System,

    tDate Date, double gCoupon )

    : tCashflow( System, Date )



{

    m_gCoupon = gCoupon;

}





//

//   t C o u p o n C a s h f l o w

//



tCouponCashflow::tCouponCashflow( const tCouponCashflow& CC )

    : tCashflow( CC )



{

    m_gCoupon = CC.m_gCoupon;

}





//

//   ~ t C a s h f l o w

//



tCouponCashflow::~tCouponCashflow()



{

}





//

//   o p e r a t o r =

//



tCouponCashflow& tCouponCashflow::operator=( const tCouponCashflow& CC )



{

    if( &CC != this )

        copyFrom( CC );

    return *this;

}





//

//   c l o n e

//



tCashflow* tCouponCashflow::clone() const



{

    return new tCouponCashflow( *this );

}



MTG_END_NAMESPACE