// Copyright 1999, 2002 Robert Buff

// Contact: http://robertbuff.com/uvm

//

// This file is part of Mtg-Book.

//

// Mtg-Book is free software; you can redistribute it and/or modify

// it under the terms of the GNU General Public License as published

// by the Free Software Foundation; either version 2 of the License,

// or (at your option) any later version.

//

// Mtg-Book is distributed in the hope that it will be useful,

// but WITHOUT ANY WARRANTY; without even the implied warranty of

// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the

// GNU General Public License for more details.

//

// You should have received a copy of the GNU General Public License

// along with Mtg-Book; if not, write to the 

//

// Free Software Foundation, Inc.

// 59 Temple Place, Suite 330

// Boston, MA 02111-1307

// USA



#if ! defined(_MTG_COUPON_CASHFLOW_)

#define _MTG_COUPON_CASHFLOW_



#include "MtgCashflow.h"



MTG_BEGIN_NAMESPACE





//

//   t C o u p o n C a s h f l o w

//



class tCouponCashflow : public tCashflow {



    typedef tCashflow super;



    double m_gCoupon;



    void copyFrom( const tCouponCashflow& CC );



    double generate( tEngine& Engine, const tClaim& Claim );



public:



    tCouponCashflow( tSystem& System, int nDay, double gCoupon );

    tCouponCashflow( tSystem& System, tDate Date, double gCoupon );



    tCouponCashflow( const tCouponCashflow& CC );



    ~tCouponCashflow();



    tCouponCashflow& operator=( const tCouponCashflow& CC );



    tCashflow* clone() const;



    double coupon() const {

        return m_gCoupon;

    }

};



MTG_END_NAMESPACE



#endif



