// Copyright 1999, 2002 Robert Buff

// Contact: http://robertbuff.com/uvm

//

// This file is part of Mtg-Book.

//

// Mtg-Book is free software; you can redistribute it and/or modify

// it under the terms of the GNU General Public License as published

// by the Free Software Foundation; either version 2 of the License,

// or (at your option) any later version.

//

// Mtg-Book is distributed in the hope that it will be useful,

// but WITHOUT ANY WARRANTY; without even the implied warranty of

// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the

// GNU General Public License for more details.

//

// You should have received a copy of the GNU General Public License

// along with Mtg-Book; if not, write to the 

//

// Free Software Foundation, Inc.

// 59 Temple Place, Suite 330

// Boston, MA 02111-1307

// USA



#if ! defined(_MTG_CURVE_)

#define _MTG_CURVE_



#include "MtgObject.h"

#include "MtgDateRange.h"

#include "MtgFileName.h"

#include "MtgHeap.h"



MTG_BEGIN_NAMESPACE



class tCurveInstance;

class tEngine;

class tPathSpace;

class tPortfolio;





//

//   t C u r v e

//



class tCurve : public tObject, public tDateRange {



    typedef tObject super;



    tHeap<double> m_Sample;     // the values of the curve

    tFileName m_InSampleFile;   // load samples from here



    tFileName m_OutSampleFile;  // save samples plain here

    tFileName m_OutDriftFile;   // save samples as drift here



    tFileName m_OutGnuDataFile; // save samples for gnuplot here    

    tFileName m_OutGnuTicsFile; // save ticmarks for gnuplot here

    int m_nNumOfGnuBins;        // number of bins for gnuplot output



    bool m_bHasMaturity;        // is maturity _date_ known?

    tDate m_Maturity;           // entered, from portfolio or path space



    double m_gCutoffYear;       // after maturity has been initialized,

    int m_nCutoffClaim;         // it may be reduced in different ways



    tFileName m_OutFile;        // for saving the entire curve, later



    tPortfolio* m_pPortfolio;   // referenced

    tPathSpace* m_pPathSpace;   // referenced



    void init();



    tRetCode saveGnuTics( ofstream& Out, int nNumOfBins ) const;

    tRetCode saveGnuTics( ofstream& Out, int nNumOfBins,

        const tPortfolio& Portfolio ) const;



    tRetCode autoSave( const tHeap<double>& Sample ) const;



    tRetCode parseSample( tParser& Parser );

    tRetCode parseSave( tParser& Parser );

    tRetCode parseCutoff( tParser& Parser );



protected:



    struct tParseInfo : super::tParseInfoStub {

        bool m_bBase;

        bool m_bScale;         

        bool m_bDayCount;      

        bool m_bParam1;

        bool m_bParam2;

    };



    void copyFrom( const tCurve& Curve );



    tRetCode parsePrefix( tParser& Parser, tParseInfoStub& Info );

    tRetCode parseParam( tParser& Parser, tParseInfoStub& Info );

    tRetCode parsePostfix( tParser& Parser, tParseInfoStub& Info );



public:



    tCurve();



        // Passed on to the tDateRange constructor:



    tCurve( tScale nScale );

    tCurve( tScale nScale, int nNumOfPeriods );

    tCurve( tScale nScale, const tDayCount& DayCount );

    tCurve( tScale nScale, int nNumOfPeriods,

        const tDayCount& DayCount );

    tCurve( tScale nScale, const tDayCount& DayCount,

        tDate Base );

    tCurve( tScale nScale, int nNumOfPeriods,

        const tDayCount& DayCount, tDate Base );



    tCurve( const tCurve& Curve );



    ~tCurve();



    tRetCode finalize();



        // Need to create a curve instance to actually

        // compute the curve:



    virtual tRetCode createInstance( tEngine& Engine,

        tCurveInstance*& pCurve ) const = 0;



        // The computed curve can be stored back:



    tRetCode modifySample( const tHeap<double>& Sample );

    tRetCode modifySample( const tCurveInstance& Curve );



        // Output the entire object, plus extra output defined

        // in attributes:



    tRetCode save( ostream& Out, const tHeap<double>* pSample ) const;

    tRetCode save( ostream& Out, const tHeap<double>& Sample ) const;

    tRetCode save( ostream& Out, const tCurveInstance& Curve ) const;

    tRetCode save( ostream& Out ) const;



        // In this case, the filename overrides m_OutFile if it is

        // not empty.



    tRetCode save( tFileName& Out, const tHeap<double>* pSample ) const;

    tRetCode save( tFileName& Out, const tHeap<double>& Sample ) const;

    tRetCode save( tFileName& Out, const tCurveInstance& Curve ) const;

    tRetCode save( tFileName& Out ) const;



        // Finally, here we list only if m_OutFile is valid.



    tRetCode save( const tHeap<double>* pSample ) const;

    tRetCode save( const tHeap<double>& Sample ) const;

    tRetCode save( const tCurveInstance& Curve ) const;

    tRetCode save() const;



    static tRetCode parse( tParser& Parser, tSystem& System, tObject*& pObj );

};



MTG_END_NAMESPACE



#endif

